unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls;

type
  TForm1 = class(TForm)
    Button1: TButton;
    Button2: TButton;
    Button3: TButton;
    Button4: TButton;
    Button5: TButton;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure Button5Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation uses WinSvc, Registry;

{$R *.DFM}

procedure TForm1.Button1Click(Sender: TObject);
var
  SvcMgr, Svc: Integer;
  i: Integer;
  Success: Boolean;
  Msg: string;
begin
  SvcMgr := OpenSCManager(nil, nil, SC_MANAGER_ALL_ACCESS);
  if SvcMgr = 0 then RaiseLastWin32Error;

svc:= CreateService(SvcMgr,
'InterBaseGuardian',
'InterBase Guardian',
 SERVICE_ALL_ACCESS,
 SERVICE_WIN32_OWN_PROCESS or SERVICE_INTERACTIVE_PROCESS,
 SERVICE_AUTO_START, // alternative is SERVICE_DEMAND_START
 SERVICE_ERROR_NORMAL,
 'C:\\IntrBase\\bin\\ibguard.exe -s',
 Nil, Nil, Nil, Nil, Nil);

 if Svc = 0 then
    RaiseLastWin32Error;

 CloseServiceHandle(svc);
 CloseServiceHandle(SvcMgr);
end;

procedure TForm1.Button2Click(Sender: TObject);
var
 Svc, SvcMgr: integer;
begin
  SvcMgr := OpenSCManager(nil, nil, SC_MANAGER_ALL_ACCESS);
  if SvcMgr = 0 then RaiseLastWin32Error;

  Svc := OpenService(SvcMgr, 'InterBaseGuardian', SERVICE_ALL_ACCESS);

  try
    if not DeleteService(Svc) then RaiseLastWin32Error;
  finally
    CloseServiceHandle(Svc);
  end;

  CloseServiceHandle(SvcMgr);

end;

procedure TForm1.Button3Click(Sender: TObject);
var
  SvcMgr, Svc: Integer;
  i: Integer;
  Success: Boolean;
  Msg: string;
begin
  SvcMgr := OpenSCManager(nil, nil, SC_MANAGER_ALL_ACCESS);
  if SvcMgr = 0 then RaiseLastWin32Error;

svc:= CreateService(SvcMgr,
'InterBaseServer',
'InterBase Server',
 SERVICE_ALL_ACCESS,
 SERVICE_WIN32_OWN_PROCESS or SERVICE_INTERACTIVE_PROCESS,
 SERVICE_DEMAND_START, // alternative is SERVICE_DEMAND_START
 SERVICE_ERROR_NORMAL,
 'C:\\IntrBase\\bin\\ibserver.exe -s -g',
 Nil, Nil, Nil, Nil, Nil);

 if Svc = 0 then
    RaiseLastWin32Error;

 CloseServiceHandle(svc);
 CloseServiceHandle(SvcMgr);
end;

procedure TForm1.Button4Click(Sender: TObject);
var
 Svc, SvcMgr: integer;
begin
  SvcMgr := OpenSCManager(nil, nil, SC_MANAGER_ALL_ACCESS);
  if SvcMgr = 0 then RaiseLastWin32Error;

  Svc := OpenService(SvcMgr, 'InterBaseServer', SERVICE_ALL_ACCESS);

  try
    if not DeleteService(Svc) then RaiseLastWin32Error;
  finally
    CloseServiceHandle(Svc);
  end;

  CloseServiceHandle(SvcMgr);
end;

procedure TForm1.Button5Click(Sender: TObject);
var
 R: TRegistry;
 s,g, cmd : string;
begin
 R:=TRegistry.Create;
 R.RootKey:=HKEY_LOCAL_MACHINE;
 if not R.OpenKey('SOFTWARE\Borland\Interbase\CurrentVersion', False) then
   begin
     Writeln('run INSTREG first.');
     Exit;
   end;
 try
   s:=R.ReadString('ServerDirectory');
 except
   on Exception do
     begin
       Writeln('ServerDirectory is not a string' );
       Exit;
 end;

 // check if there is a ServerDirectory string
 if s = '' then
   begin
     s:=R.ReadString('RootDirectory');
     if s = '' then
       begin
         Writeln('RootDirectory is not set. Run INSTREG first.';
         Exit;
       end;
     s:=s+'\BIN';
     // create if it does not exist
     R.WriteString('ServerDirectory', s);
   end;

 // read GuardianOptions
 try
   g:=R.ReadString('GuardianOptions');
 except
   on Exception do
     begin
       Writeln('GuardianOptions is not a string');
       Exit;
     end;
 end;

 // check if there GuardianOptions string
 if g = '' then
   begin
     g:='1'; // autorun
     R.WriteString('GuardianOptions', g);
   end;

 R.Free;

 cmd:=UpperCase(ParamStr(1));
 // params: auto, manual,

// if cmd = '
end;

end.
