unit Goods;

interface

uses
  Winapi.Windows, Winapi.Messages, System.SysUtils, System.Variants, System.Classes, Vcl.Graphics,
  Vcl.Controls, Vcl.Forms, Vcl.Dialogs, Vcl.ToolWin, Vcl.ComCtrls, Vcl.Grids,
  Vcl.DBGrids, Data.DB, Vcl.StdCtrls, Vcl.DBCtrls, Vcl.ExtCtrls, System.Actions,
  Vcl.ActnList, FireDAC.Stan.Intf, FireDAC.Stan.Option, FireDAC.Stan.Param,
  FireDAC.Stan.Error, FireDAC.DatS, FireDAC.Phys.Intf, FireDAC.DApt.Intf,
  FireDAC.Stan.Async, FireDAC.DApt, FireDAC.Comp.Client, FireDAC.Comp.DataSet;

type
  TGoodsForm = class(TForm)
    ToolBar1: TToolBar;
    DBGrid: TDBGrid;
    Splitter1: TSplitter;
    DBMemo1: TDBMemo;
    ActionList: TActionList;
    ToolButton1: TToolButton;
    ToolButton2: TToolButton;
    ToolButton3: TToolButton;
    actAddRecord: TAction;
    actEditRecord: TAction;
    actDeleteRecord: TAction;
    ToolButton4: TToolButton;
    ToolButton5: TToolButton;
    actExit: TAction;
    actRefresh: TAction;
    ToolButton6: TToolButton;
    ToolButton7: TToolButton;
    qryGoods: TFDQuery;
    qryGoodsPRODUCT_ID: TIntegerField;
    qryGoodsNAME: TWideStringField;
    qryGoodsPRICE: TFloatField;
    qryGoodsDESCRIPTION: TFDWideMemoField;
    FDUpdateGoods: TFDUpdateSQL;
    DataSource: TDataSource;
    trWrite: TFDTransaction;
    procedure FormActivate(Sender: TObject);
    procedure actAddRecordExecute(Sender: TObject);
    procedure actEditRecordExecute(Sender: TObject);
    procedure actDeleteRecordExecute(Sender: TObject);
    procedure actExitExecute(Sender: TObject);
    procedure actRefreshExecute(Sender: TObject);
    procedure DBGridDblClick(Sender: TObject);
    procedure DBGridKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
  private
    procedure GoodsEditorClose(Sender: TObject; var Action: TCloseAction);
  public
    { Public declarations }
  end;

var
  GoodsForm: TGoodsForm;

implementation

{$R *.dfm}

uses GoodsEditor;

procedure TGoodsForm.actAddRecordExecute(Sender: TObject);
var
  xEditorForm: TEditGoodsForm;
begin
  xEditorForm := TEditGoodsForm.Create(Self);
  try
    xEditorForm.OnClose := GoodsEditorClose;
    xEditorForm.DataSource := DataSource;
    xEditorForm.Caption := 'Add item';
    qryGoods.CachedUpdates := True;
    qryGoods.Insert;
    xEditorForm.ShowModal;
  finally
    xEditorForm.Free;
  end;
end;

procedure TGoodsForm.actDeleteRecordExecute(Sender: TObject);
begin
  if MessageDlg('Are you sure you want to delete the item?',
                mtConfirmation,
                [mbYes, mbNo],
                0) = mrYes then
  begin
    trWrite.StartTransaction;
    try
      qryGoods.Delete;
      trWrite.Commit;
    except
      on E: Exception do
      begin
        trWrite.Rollback;
        Application.ShowException(E);
      end;
    end;
  end;
end;

procedure TGoodsForm.actEditRecordExecute(Sender: TObject);
var
  xEditorForm: TEditGoodsForm;
begin
  xEditorForm := TEditGoodsForm.Create(Self);
  try
    xEditorForm.OnClose := GoodsEditorClose;
    xEditorForm.DataSource := DataSource;
    xEditorForm.Caption := 'Edit item';
    qryGoods.CachedUpdates := True;
    qryGoods.Edit;
    xEditorForm.ShowModal;
  finally
    xEditorForm.Free;
  end;
end;

procedure TGoodsForm.actExitExecute(Sender: TObject);
begin
  qryGoods.Close;
  Close;
end;

procedure TGoodsForm.actRefreshExecute(Sender: TObject);
begin
  qryGoods.Refresh;
end;

procedure TGoodsForm.DBGridDblClick(Sender: TObject);
begin
  if fsModal in FormState then
  begin
    ModalResult := mrOK;
    CloseModal;
  end
  else begin
    actEditRecordExecute(Self);
  end;
end;

procedure TGoodsForm.DBGridKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if (Key = VK_RETURN) and (Shift = []) then
  begin
    DBGridDblClick(Sender);
  end;
end;

procedure TGoodsForm.FormActivate(Sender: TObject);
begin
  qryGoods.Open;
end;

procedure TGoodsForm.GoodsEditorClose(Sender: TObject;
  var Action: TCloseAction);
begin
  if TEditGoodsForm(Sender).ModalResult <> mrOK then
  begin
    qryGoods.Cancel;
    qryGoods.CancelUpdates;
    qryGoods.CachedUpdates := False;
    Action := caFree;
    Exit;
  end;

  try
    qryGoods.Post;

    // We do everything in a short transaction
    // In CachedUpdates mode error does not stop running.
    // ApplyUpdates method returns the number of errors.
    // The error can be obtained from the property RowError
    trWrite.StartTransaction;
    if (qryGoods.ApplyUpdates = 0) then
    begin
      qryGoods.CommitUpdates;
      trWrite.Commit;
    end
    else begin
      raise Exception.Create(qryGoods.RowError.Message);
    end;
    qryGoods.CachedUpdates := False;
    Action := caFree;
  except
    on E: Exception do
    begin
      if trWrite.Active then
        trWrite.Rollback;
      Application.ShowException(E);
      // It does not close the window give the user correct the error
      Action := caNone;
    end;
  end;
end;

end.
