(* lex -LP -o ExprLexer.pas ExprLexer.l *)
{LINE 1 ExprLexer.l}

unit ExprLexer;
{$DEFINE YYIOSTREAMED}

interface

uses
  Windows, Classes, SysUtils, StdFuncs, StdConsts, VariantSymbolTable;

{$DEFINE YYLMAX_DEFINED}
const
  yylmax = 1023;
  yylmax1 = yylmax + 1;
  MSPEC_DAY = 1;
  MSPEC_MONTH = 2;
  MSPEC_YEAR = 3;
  EXPR_NUMTYPE_INTEGER = 1;
  EXPR_NUMTYPE_DOUBLE = 2;

type
  TExprNumber = record
    case NumType: Byte of
      1: (ivalue: Integer);
      2: (dvalue: Double);
  end;

{$I ExprParser.hp}

procedure GetString(str_delim: Integer);
procedure yyerror(msg: String);
procedure yy_reset;
function yylex: Integer;

threadvar
  yyin, yyout, yyerr: TStream;
  yyerrcnt: Integer;
  yylval: YYSTYPE;
  SymTab: TVariantSymbolTable;

implementation

procedure yyerror(msg: String);
begin
  msg := msg + CRLF;
  yyerr.WriteBuffer(msg[1], Length(msg));
  Inc(yyerrcnt);
end;
type
	yy_state_t = byte;
const
	YYNEWLINE = 10;
	INITIAL = 0;
const
	yy_endst = 86;
	yy_nxtmax = 5992;

{LINE 1 c:/etc/yylex.pas}
(*
 * 2/5/1998 - Gregory Deatz
 * gdeatz(at)hlmdd.com
 *
 * YYPARSE.PAS - A thread-safe version modified from the
 * template files distributed with MKS lex/yacc 3.2b.
 *
 * I guess MKS's copyright still stands, because I didn't change much,
 * but it would be nice if you acknowledged work where work was
 * done....
*)
(*
 * Copyright 1990, 1991 by Mortice Kern Systems Inc.
 * All rights reserved.
 *)
{$B-}		(* short circuit boolean evaluation *)
{$I-}           (* suppress I/O runtime library checks *)
{$J-}           (* Don't allow assignable constants *)

const
	YY_LA_SIZE = 11;

type tableyy_la_act = array[0..99] of word;
var yy_la_act: ^tableyy_la_act;
const tblyy_la_act: tableyy_la_act = (
 0, 29, 34, 3, 4, 5, 26, 7, 34, 34, 34, 34, 14, 20, 19, 34,
 34, 34, 34, 25, 27, 34, 34, 34, 34, 35, 34, 34, 33, 34, 34, 30,
 34, 34, 34, 31, 34, 34, 34, 32, 34, 28, 34, 34, 34, 34, 24, 34,
 34, 34, 23, 34, 34, 34, 34, 34, 34, 34, 22, 34, 34, 34, 34, 34,
 34, 34, 34, 34, 34, 21, 34, 18, 16, 17, 15, 34, 12, 34, 11, 34,
 34, 9, 34, 8, 34, 6, 34, 7, 6, 34, 34, 34, 10, 34, 2, 34,
 13, 34, 1, 0
);

type tableyy_look = array[0..0] of byte;
var yy_look: ^tableyy_look;
const tblyy_look: tableyy_look = (
 0
);

type tableyy_final = array[0..86] of integer;
var yy_final: ^tableyy_final;
const tblyy_final: tableyy_final = (
 0, 0, 1, 2, 3, 4, 5, 6, 7, 9, 9, 10, 11, 12, 13, 13,
 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 30,
 31, 33, 34, 35, 37, 38, 39, 41, 43, 44, 45, 46, 48, 49, 50, 52,
 53, 54, 55, 56, 57, 58, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69,
 71, 72, 73, 74, 75, 76, 78, 80, 81, 83, 84, 85, 87, 88, 88, 89,
 90, 91, 92, 94, 96, 98, 99
);

type tableyy_begin = array[0..2] of yy_state_t;
var yy_begin: ^tableyy_begin;
const tblyy_begin: tableyy_begin = (
 0, 0, 0
);

type tableyy_next = array[0..5993] of yy_state_t;
var yy_next: ^tableyy_next;
const tblyy_next: tableyy_next = (
 86, 86, 86, 86, 86, 86, 86, 86, 86, 27, 27, 86, 86, 27, 27, 27,
 86, 86, 27, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86,
 27, 14, 4, 86, 9, 27, 86, 5, 1, 1, 22, 21, 85, 7, 26, 2,
 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 77, 86, 15, 13, 16, 64,
 67, 10, 26, 18, 23, 26, 20, 26, 26, 26, 26, 26, 26, 24, 3, 11,
 26, 26, 26, 17, 19, 26, 26, 26, 12, 25, 26, 66, 65, 86, 86, 26,
 86, 10, 26, 18, 23, 26, 20, 26, 26, 26, 26, 26, 26, 24, 3, 11,
 26, 26, 26, 17, 19, 26, 26, 26, 12, 25, 26, 6, 86, 86, 86, 86,
 86, 73, 73, 73, 73, 73, 73, 73, 73, 73, 73, 86, 86, 86, 86, 86,
 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86,
 86, 86, 86, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 86, 86, 86,
 86, 86, 86, 86, 26, 86, 26, 26, 86, 26, 86, 86, 86, 86, 86, 86,
 26, 26, 26, 86, 86, 86, 26, 26, 86, 86, 86, 26, 26, 86, 86, 86,
 86, 86, 86, 86, 26, 86, 26, 26, 86, 26, 86, 86, 86, 86, 86, 86,
 26, 26, 26, 86, 86, 86, 26, 26, 86, 86, 86, 26, 26, 86, 86, 86,
 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86,
 86, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 86, 86, 86, 86, 86,
 86, 86, 26, 86, 26, 26, 28, 26, 86, 86, 86, 86, 86, 86, 26, 26,
 26, 86, 86, 86, 26, 26, 86, 86, 86, 26, 26, 86, 86, 86, 86, 86,
 86, 86, 26, 86, 26, 26, 28, 26, 86, 86, 86, 86, 86, 86, 26, 26,
 26, 86, 86, 86, 26, 26, 86, 86, 86, 26, 26, 86, 86, 86, 86, 86,
 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 26,
 26, 26, 26, 26, 26, 26, 26, 26, 26, 86, 86, 86, 86, 86, 86, 86,
 29, 86, 26, 26, 86, 26, 86, 86, 86, 86, 86, 86, 26, 26, 26, 86,
 86, 86, 26, 26, 86, 86, 86, 26, 26, 86, 86, 86, 86, 86, 86, 86,
 29, 86, 26, 26, 86, 26, 86, 86, 86, 86, 86, 86, 26, 26, 26, 86,
 86, 86, 26, 26, 86, 86, 86, 26, 26, 86, 86, 86, 86, 86, 86, 86,
 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 26, 26, 26,
 26, 26, 26, 26, 26, 26, 26, 86, 86, 86, 86, 86, 86, 86, 26, 86,
 26, 26, 86, 26, 86, 86, 86, 86, 86, 86, 26, 26, 26, 86, 86, 30,
 26, 26, 86, 86, 86, 26, 26, 86, 86, 86, 86, 86, 86, 86, 26, 86,
 26, 26, 86, 26, 86, 86, 86, 86, 86, 86, 26, 26, 26, 86, 86, 30,
 26, 26, 86, 86, 86, 26, 26, 86, 86, 86, 86, 86, 86, 86, 86, 86,
 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 26, 26, 26, 26, 26,
 26, 26, 26, 26, 26, 86, 86, 86, 86, 86, 86, 86, 26, 86, 26, 26,
 86, 26, 86, 86, 86, 86, 86, 86, 26, 26, 26, 86, 86, 86, 26, 26,
 86, 86, 86, 26, 26, 86, 86, 86, 86, 86, 86, 86, 26, 86, 26, 26,
 86, 26, 86, 86, 86, 86, 86, 86, 26, 26, 26, 86, 86, 86, 26, 26,
 86, 86, 86, 26, 26, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86,
 86, 86, 86, 86, 86, 86, 86, 86, 86, 26, 26, 26, 26, 26, 26, 26,
 26, 26, 26, 86, 86, 86, 86, 86, 86, 86, 26, 86, 26, 26, 86, 26,
 86, 86, 86, 86, 86, 86, 26, 26, 31, 86, 86, 86, 26, 26, 86, 86,
 86, 26, 26, 86, 86, 86, 86, 86, 86, 86, 26, 86, 26, 26, 86, 26,
 86, 86, 86, 86, 86, 86, 26, 26, 31, 86, 86, 86, 26, 26, 86, 86,
 86, 26, 26, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86,
 86, 86, 86, 86, 86, 86, 86, 26, 26, 26, 26, 26, 26, 26, 26, 26,
 26, 86, 86, 86, 86, 86, 86, 86, 26, 86, 26, 32, 86, 26, 86, 86,
 86, 86, 86, 86, 26, 33, 26, 86, 86, 86, 26, 26, 86, 86, 86, 26,
 26, 86, 86, 86, 86, 86, 86, 86, 26, 86, 26, 32, 86, 26, 86, 86,
 86, 86, 86, 86, 26, 33, 26, 86, 86, 86, 26, 26, 86, 86, 86, 26,
 26, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86,
 86, 86, 86, 86, 86, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 86,
 86, 86, 86, 86, 86, 86, 26, 86, 26, 26, 86, 26, 86, 86, 86, 86,
 86, 86, 26, 26, 26, 86, 86, 86, 26, 34, 86, 86, 86, 26, 26, 86,
 86, 86, 86, 86, 86, 86, 26, 86, 26, 26, 86, 26, 86, 86, 86, 86,
 86, 86, 26, 26, 26, 86, 86, 86, 26, 34, 86, 86, 86, 26, 26, 86,
 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86,
 86, 86, 86, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 86, 86, 86,
 86, 86, 86, 86, 26, 86, 26, 26, 86, 26, 86, 35, 86, 86, 86, 86,
 26, 26, 26, 86, 86, 86, 26, 26, 86, 86, 86, 26, 26, 86, 86, 86,
 86, 86, 86, 86, 26, 86, 26, 26, 86, 26, 86, 35, 86, 86, 86, 86,
 26, 26, 26, 86, 86, 86, 26, 26, 86, 86, 86, 26, 26, 86, 86, 76,
 76, 76, 76, 76, 76, 76, 76, 76, 76, 86, 86, 86, 86, 86, 86, 86,
 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 26, 26, 26, 26, 26,
 26, 26, 26, 26, 26, 86, 86, 86, 86, 86, 86, 86, 26, 86, 26, 26,
 86, 26, 86, 86, 86, 86, 86, 86, 26, 26, 26, 86, 86, 86, 26, 26,
 86, 86, 86, 26, 26, 86, 86, 86, 86, 86, 86, 86, 26, 86, 26, 26,
 86, 26, 86, 86, 86, 86, 86, 86, 26, 26, 26, 86, 86, 86, 26, 26,
 86, 86, 86, 26, 26, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86,
 86, 86, 86, 86, 86, 86, 86, 86, 86, 26, 26, 26, 26, 26, 26, 26,
 26, 26, 26, 86, 86, 86, 86, 86, 86, 86, 26, 86, 26, 26, 86, 26,
 86, 86, 86, 86, 86, 86, 26, 26, 26, 86, 86, 86, 26, 26, 86, 86,
 86, 26, 26, 86, 86, 86, 86, 86, 86, 86, 26, 86, 26, 26, 86, 26,
 86, 86, 86, 86, 86, 86, 26, 26, 26, 86, 86, 86, 26, 26, 86, 86,
 86, 26, 26, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86,
 86, 86, 86, 86, 86, 86, 86, 26, 26, 26, 26, 26, 26, 26, 26, 26,
 26, 86, 86, 86, 86, 86, 86, 86, 37, 86, 26, 26, 86, 26, 86, 86,
 36, 86, 86, 86, 26, 26, 26, 86, 86, 86, 26, 26, 86, 86, 86, 26,
 26, 86, 86, 86, 86, 86, 86, 86, 37, 86, 26, 26, 86, 26, 86, 86,
 36, 86, 86, 86, 26, 26, 26, 86, 86, 86, 26, 26, 86, 86, 86, 26,
 26, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86,
 86, 86, 86, 86, 86, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 86,
 86, 86, 86, 86, 86, 86, 26, 86, 26, 26, 86, 26, 86, 86, 86, 86,
 86, 86, 26, 26, 26, 86, 86, 86, 26, 26, 86, 86, 86, 26, 38, 86,
 86, 86, 86, 86, 86, 86, 26, 86, 26, 26, 86, 26, 86, 86, 86, 86,
 86, 86, 26, 26, 26, 86, 86, 86, 26, 26, 86, 86, 86, 26, 38, 86,
 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86,
 86, 86, 86, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 86, 86, 86,
 86, 86, 86, 86, 26, 86, 26, 26, 86, 26, 86, 86, 86, 86, 86, 86,
 26, 26, 26, 86, 86, 86, 26, 26, 86, 86, 86, 26, 26, 86, 86, 86,
 86, 86, 86, 86, 26, 86, 26, 26, 86, 26, 86, 86, 86, 86, 86, 86,
 26, 26, 26, 86, 86, 86, 26, 26, 86, 86, 86, 26, 26, 86, 86, 86,
 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86,
 86, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 86, 86, 86, 86, 86,
 86, 86, 26, 86, 26, 26, 86, 26, 86, 86, 86, 86, 86, 86, 26, 26,
 26, 86, 86, 86, 26, 26, 86, 39, 86, 26, 26, 86, 86, 86, 86, 86,
 86, 86, 26, 86, 26, 26, 86, 26, 86, 86, 86, 86, 86, 86, 26, 26,
 26, 86, 86, 86, 26, 26, 86, 39, 86, 26, 26, 86, 86, 86, 86, 86,
 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 26,
 26, 26, 26, 26, 26, 26, 26, 26, 26, 86, 86, 86, 86, 86, 86, 86,
 26, 86, 26, 26, 86, 26, 86, 86, 86, 86, 86, 86, 26, 26, 26, 86,
 86, 86, 26, 26, 86, 86, 86, 26, 26, 86, 86, 86, 86, 86, 86, 86,
 26, 86, 26, 26, 86, 26, 86, 86, 86, 86, 86, 86, 26, 26, 26, 86,
 86, 86, 26, 26, 86, 86, 86, 26, 26, 86, 86, 86, 86, 86, 86, 86,
 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 26, 26, 26,
 26, 26, 26, 26, 26, 26, 26, 86, 86, 86, 86, 86, 86, 86, 40, 86,
 26, 26, 86, 26, 86, 86, 86, 86, 86, 86, 26, 26, 26, 86, 86, 86,
 26, 26, 86, 86, 86, 26, 26, 86, 86, 86, 86, 86, 86, 86, 40, 86,
 26, 26, 86, 26, 86, 86, 86, 86, 86, 86, 26, 26, 26, 86, 86, 86,
 26, 26, 86, 86, 86, 26, 26, 86, 86, 86, 86, 86, 86, 86, 86, 86,
 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 26, 26, 26, 26, 26,
 26, 26, 26, 26, 26, 86, 86, 86, 86, 86, 86, 86, 26, 86, 26, 26,
 86, 26, 86, 86, 86, 86, 86, 41, 26, 26, 26, 86, 86, 86, 26, 26,
 86, 86, 86, 26, 26, 86, 86, 86, 86, 86, 86, 86, 26, 86, 26, 26,
 86, 26, 86, 86, 86, 86, 86, 41, 26, 26, 26, 86, 86, 86, 26, 26,
 86, 86, 86, 26, 26, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86,
 86, 86, 86, 86, 86, 86, 86, 86, 86, 26, 26, 26, 26, 26, 26, 26,
 26, 26, 26, 86, 86, 86, 86, 86, 86, 86, 26, 86, 26, 26, 86, 26,
 86, 86, 86, 86, 86, 86, 26, 26, 26, 86, 86, 86, 42, 26, 86, 86,
 86, 26, 26, 86, 86, 86, 86, 86, 86, 86, 26, 86, 26, 26, 86, 26,
 86, 86, 86, 86, 86, 86, 26, 26, 26, 86, 86, 86, 42, 26, 86, 86,
 86, 26, 26, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86,
 86, 86, 86, 86, 86, 86, 86, 26, 26, 26, 26, 26, 26, 26, 26, 26,
 26, 86, 86, 86, 86, 86, 86, 86, 26, 86, 26, 26, 43, 26, 86, 86,
 86, 86, 86, 86, 26, 26, 26, 86, 86, 86, 26, 26, 86, 86, 86, 26,
 26, 86, 86, 86, 86, 86, 86, 86, 26, 86, 26, 26, 43, 26, 86, 86,
 86, 86, 86, 86, 26, 26, 26, 86, 86, 86, 26, 26, 86, 86, 86, 26,
 26, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86,
 86, 86, 86, 86, 86, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 86,
 86, 86, 86, 86, 86, 86, 26, 86, 26, 26, 86, 26, 86, 86, 86, 86,
 86, 86, 26, 26, 26, 86, 86, 86, 26, 26, 86, 86, 86, 26, 26, 86,
 86, 86, 86, 86, 86, 86, 26, 86, 26, 26, 86, 26, 86, 86, 86, 86,
 86, 86, 26, 26, 26, 86, 86, 86, 26, 26, 86, 86, 86, 26, 26, 86,
 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86,
 86, 86, 86, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 86, 86, 86,
 86, 86, 86, 86, 26, 86, 26, 26, 86, 26, 86, 86, 86, 86, 86, 86,
 26, 26, 26, 86, 86, 44, 26, 26, 86, 86, 86, 26, 26, 86, 86, 86,
 86, 86, 86, 86, 26, 86, 26, 26, 86, 26, 86, 86, 86, 86, 86, 86,
 26, 26, 26, 86, 86, 44, 26, 26, 86, 86, 86, 26, 26, 86, 86, 86,
 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86,
 86, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 86, 86, 86, 86, 86,
 86, 86, 26, 86, 26, 26, 86, 26, 86, 86, 86, 86, 86, 86, 26, 26,
 26, 86, 86, 86, 26, 26, 45, 86, 86, 26, 26, 86, 86, 86, 86, 86,
 86, 86, 26, 86, 26, 26, 86, 26, 86, 86, 86, 86, 86, 86, 26, 26,
 26, 86, 86, 86, 26, 26, 45, 86, 86, 26, 26, 86, 86, 86, 86, 86,
 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 26,
 26, 26, 26, 26, 26, 26, 26, 26, 26, 86, 86, 86, 86, 86, 86, 86,
 26, 86, 26, 26, 46, 26, 86, 86, 86, 86, 86, 86, 26, 26, 26, 86,
 86, 86, 26, 26, 86, 86, 86, 26, 26, 86, 86, 86, 86, 86, 86, 86,
 26, 86, 26, 26, 46, 26, 86, 86, 86, 86, 86, 86, 26, 26, 26, 86,
 86, 86, 26, 26, 86, 86, 86, 26, 26, 86, 86, 86, 86, 86, 86, 86,
 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 26, 26, 26,
 26, 26, 26, 26, 26, 26, 26, 86, 86, 86, 86, 86, 86, 86, 26, 86,
 26, 26, 86, 26, 86, 86, 86, 86, 86, 86, 26, 26, 26, 86, 86, 86,
 26, 26, 86, 86, 86, 26, 26, 86, 86, 86, 86, 86, 86, 86, 26, 86,
 26, 26, 86, 26, 86, 86, 86, 86, 86, 86, 26, 26, 26, 86, 86, 86,
 26, 26, 86, 86, 86, 26, 26, 86, 86, 86, 86, 86, 86, 86, 86, 86,
 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 26, 26, 26, 26, 26,
 26, 26, 26, 26, 26, 86, 86, 86, 86, 86, 86, 86, 26, 86, 26, 26,
 86, 26, 86, 86, 86, 86, 86, 86, 26, 26, 47, 86, 86, 86, 26, 26,
 86, 86, 86, 26, 26, 86, 86, 86, 86, 86, 86, 86, 26, 86, 26, 26,
 86, 26, 86, 86, 86, 86, 86, 86, 26, 26, 47, 86, 86, 86, 26, 26,
 86, 86, 86, 26, 26, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86,
 86, 86, 86, 86, 86, 86, 86, 86, 86, 26, 26, 26, 26, 26, 26, 26,
 26, 26, 26, 86, 86, 86, 86, 86, 86, 86, 26, 86, 26, 26, 86, 26,
 86, 86, 86, 86, 86, 86, 26, 48, 26, 86, 86, 86, 26, 26, 86, 86,
 86, 26, 26, 86, 86, 86, 86, 86, 86, 86, 26, 86, 26, 26, 86, 26,
 86, 86, 86, 86, 86, 86, 26, 48, 26, 86, 86, 86, 26, 26, 86, 86,
 86, 26, 26, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86,
 86, 86, 86, 86, 86, 86, 86, 26, 26, 26, 26, 26, 26, 26, 26, 26,
 26, 86, 86, 86, 86, 86, 86, 86, 26, 86, 26, 26, 86, 26, 86, 86,
 86, 86, 86, 86, 26, 26, 26, 86, 86, 86, 26, 49, 86, 86, 86, 26,
 26, 86, 86, 86, 86, 86, 86, 86, 26, 86, 26, 26, 86, 26, 86, 86,
 86, 86, 86, 86, 26, 26, 26, 86, 86, 86, 26, 49, 86, 86, 86, 26,
 26, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86,
 86, 86, 86, 86, 86, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 86,
 86, 86, 86, 86, 86, 86, 50, 86, 26, 26, 86, 26, 86, 86, 86, 86,
 86, 86, 26, 26, 26, 86, 86, 86, 26, 26, 86, 86, 86, 26, 26, 86,
 86, 86, 86, 86, 86, 86, 50, 86, 26, 26, 86, 26, 86, 86, 86, 86,
 86, 86, 26, 26, 26, 86, 86, 86, 26, 26, 86, 86, 86, 26, 26, 86,
 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86,
 86, 86, 86, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 86, 86, 86,
 86, 86, 86, 86, 26, 86, 26, 26, 86, 26, 86, 86, 51, 86, 86, 86,
 26, 26, 26, 86, 86, 86, 26, 26, 86, 86, 86, 26, 26, 86, 86, 86,
 86, 86, 86, 86, 26, 86, 26, 26, 86, 26, 86, 86, 51, 86, 86, 86,
 26, 26, 26, 86, 86, 86, 26, 26, 86, 86, 86, 26, 26, 86, 86, 86,
 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86,
 86, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 86, 86, 86, 86, 86,
 86, 86, 26, 86, 26, 26, 86, 26, 86, 86, 86, 86, 86, 86, 26, 52,
 26, 86, 86, 86, 26, 26, 86, 86, 86, 26, 26, 86, 86, 86, 86, 86,
 86, 86, 26, 86, 26, 26, 86, 26, 86, 86, 86, 86, 86, 86, 26, 52,
 26, 86, 86, 86, 26, 26, 86, 86, 86, 26, 26, 86, 86, 86, 86, 86,
 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 26,
 26, 26, 26, 26, 26, 26, 26, 26, 26, 86, 86, 86, 86, 86, 86, 86,
 26, 86, 26, 26, 86, 26, 86, 86, 86, 86, 86, 86, 26, 26, 26, 86,
 86, 86, 53, 26, 86, 86, 86, 26, 26, 86, 86, 86, 86, 86, 86, 86,
 26, 86, 26, 26, 86, 26, 86, 86, 86, 86, 86, 86, 26, 26, 26, 86,
 86, 86, 53, 26, 86, 86, 86, 26, 26, 86, 86, 86, 86, 86, 86, 86,
 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 26, 26, 26,
 26, 26, 26, 26, 26, 26, 26, 86, 86, 86, 86, 86, 86, 86, 26, 86,
 26, 26, 86, 26, 86, 86, 86, 86, 86, 86, 26, 26, 26, 86, 86, 86,
 26, 26, 86, 86, 86, 26, 26, 86, 86, 86, 86, 86, 86, 86, 26, 86,
 26, 26, 86, 26, 86, 86, 86, 86, 86, 86, 26, 26, 26, 86, 86, 86,
 26, 26, 86, 86, 86, 26, 26, 86, 86, 86, 86, 86, 86, 86, 86, 86,
 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 26, 26, 26, 26, 26,
 26, 26, 26, 26, 26, 86, 86, 86, 86, 86, 86, 86, 26, 86, 26, 26,
 86, 26, 86, 86, 86, 86, 86, 86, 26, 26, 26, 86, 86, 86, 26, 54,
 86, 86, 86, 26, 26, 86, 86, 86, 86, 86, 86, 86, 26, 86, 26, 26,
 86, 26, 86, 86, 86, 86, 86, 86, 26, 26, 26, 86, 86, 86, 26, 54,
 86, 86, 86, 26, 26, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86,
 86, 86, 86, 86, 86, 86, 86, 86, 86, 26, 26, 26, 26, 26, 26, 26,
 26, 26, 26, 86, 86, 86, 86, 86, 86, 86, 55, 86, 26, 26, 86, 26,
 86, 86, 86, 86, 86, 86, 26, 26, 26, 86, 86, 86, 26, 26, 86, 86,
 86, 26, 26, 86, 86, 86, 86, 86, 86, 86, 55, 86, 26, 26, 86, 26,
 86, 86, 86, 86, 86, 86, 26, 26, 26, 86, 86, 86, 26, 26, 86, 86,
 86, 26, 26, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86,
 86, 86, 86, 86, 86, 86, 86, 26, 26, 26, 26, 26, 26, 26, 26, 26,
 26, 86, 86, 86, 86, 86, 86, 86, 26, 86, 26, 26, 86, 26, 86, 86,
 86, 86, 86, 86, 26, 26, 26, 86, 86, 56, 26, 26, 86, 86, 86, 26,
 26, 86, 86, 86, 86, 86, 86, 86, 26, 86, 26, 26, 86, 26, 86, 86,
 86, 86, 86, 86, 26, 26, 26, 86, 86, 56, 26, 26, 86, 86, 86, 26,
 26, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86,
 86, 86, 86, 86, 86, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 86,
 86, 86, 86, 86, 86, 86, 26, 86, 26, 26, 86, 26, 86, 86, 86, 86,
 86, 86, 26, 26, 26, 86, 86, 86, 26, 57, 86, 86, 86, 26, 26, 86,
 86, 86, 86, 86, 86, 86, 26, 86, 26, 26, 86, 26, 86, 86, 86, 86,
 86, 86, 26, 26, 26, 86, 86, 86, 26, 57, 86, 86, 86, 26, 26, 86,
 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86,
 86, 86, 86, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 86, 86, 86,
 86, 86, 86, 86, 26, 86, 26, 26, 86, 26, 86, 86, 86, 86, 86, 86,
 26, 26, 26, 86, 86, 86, 58, 26, 86, 86, 86, 26, 26, 86, 86, 86,
 86, 86, 86, 86, 26, 86, 26, 26, 86, 26, 86, 86, 86, 86, 86, 86,
 26, 26, 26, 86, 86, 86, 58, 26, 86, 86, 86, 26, 26, 86, 86, 86,
 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86,
 86, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 86, 86, 86, 86, 86,
 86, 86, 26, 86, 26, 26, 86, 26, 86, 86, 86, 86, 86, 86, 26, 26,
 26, 86, 86, 86, 26, 26, 86, 86, 86, 26, 26, 86, 86, 86, 86, 86,
 59, 86, 26, 86, 26, 26, 86, 26, 86, 86, 86, 86, 86, 86, 26, 26,
 26, 86, 86, 86, 26, 26, 86, 86, 86, 26, 26, 86, 86, 86, 86, 86,
 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 26,
 26, 26, 26, 26, 26, 26, 26, 26, 26, 86, 86, 86, 86, 86, 86, 86,
 26, 86, 26, 26, 86, 26, 86, 86, 86, 86, 86, 86, 26, 26, 26, 86,
 86, 86, 26, 26, 86, 86, 60, 26, 26, 86, 86, 86, 86, 86, 86, 86,
 26, 86, 26, 26, 86, 26, 86, 86, 86, 86, 86, 86, 26, 26, 26, 86,
 86, 86, 26, 26, 86, 86, 60, 26, 26, 86, 86, 86, 86, 86, 86, 86,
 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 26, 26, 26,
 26, 26, 26, 26, 26, 26, 26, 86, 86, 86, 86, 86, 86, 86, 26, 86,
 26, 26, 86, 26, 86, 86, 61, 86, 86, 86, 26, 26, 26, 86, 86, 86,
 26, 26, 86, 86, 86, 26, 26, 86, 86, 86, 86, 86, 86, 86, 26, 86,
 26, 26, 86, 26, 86, 86, 61, 86, 86, 86, 26, 26, 26, 86, 86, 86,
 26, 26, 86, 86, 86, 26, 26, 86, 86, 86, 86, 86, 86, 86, 86, 86,
 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 26, 26, 26, 26, 26,
 26, 26, 26, 26, 26, 86, 86, 86, 86, 86, 86, 86, 26, 86, 26, 26,
 86, 26, 86, 86, 86, 86, 86, 86, 26, 26, 26, 86, 86, 86, 26, 62,
 86, 86, 86, 26, 26, 86, 86, 86, 86, 86, 86, 86, 26, 86, 26, 26,
 86, 26, 86, 86, 86, 86, 86, 86, 26, 26, 26, 86, 86, 86, 26, 62,
 86, 86, 86, 26, 26, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86,
 86, 86, 86, 86, 86, 86, 86, 86, 86, 26, 26, 26, 26, 26, 26, 26,
 26, 26, 26, 86, 86, 86, 86, 86, 86, 86, 26, 86, 26, 26, 86, 26,
 86, 63, 86, 86, 86, 86, 26, 26, 26, 86, 86, 86, 26, 26, 86, 86,
 86, 26, 26, 86, 86, 86, 86, 86, 86, 86, 26, 86, 26, 26, 86, 26,
 86, 63, 86, 86, 86, 86, 26, 26, 26, 86, 86, 86, 26, 26, 86, 86,
 86, 26, 26, 86, 86, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 86,
 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86,
 86, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 86, 86, 86, 86, 86,
 86, 86, 26, 86, 26, 26, 86, 26, 86, 86, 86, 86, 86, 86, 26, 26,
 26, 86, 86, 86, 26, 26, 86, 86, 86, 26, 26, 86, 86, 86, 86, 86,
 86, 86, 26, 86, 26, 26, 86, 26, 86, 86, 86, 86, 86, 86, 26, 26,
 26, 86, 86, 86, 26, 26, 86, 86, 86, 26, 26, 86, 86, 86, 86, 86,
 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 26,
 26, 26, 26, 26, 26, 26, 26, 26, 26, 86, 86, 86, 86, 86, 86, 86,
 26, 86, 26, 26, 86, 26, 86, 86, 86, 86, 86, 86, 26, 26, 68, 86,
 86, 86, 26, 26, 86, 86, 86, 26, 26, 86, 86, 86, 86, 86, 86, 86,
 26, 86, 26, 26, 86, 26, 86, 86, 86, 86, 86, 86, 26, 26, 68, 86,
 86, 86, 26, 26, 86, 86, 86, 26, 26, 86, 86, 86, 86, 86, 86, 86,
 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 26, 26, 26,
 26, 26, 26, 26, 26, 26, 26, 86, 86, 86, 86, 86, 86, 86, 26, 86,
 26, 26, 86, 26, 86, 86, 86, 86, 86, 86, 26, 26, 26, 86, 86, 69,
 26, 26, 86, 86, 86, 26, 26, 86, 86, 86, 86, 86, 86, 86, 26, 86,
 26, 26, 86, 26, 86, 86, 86, 86, 86, 86, 26, 26, 26, 86, 86, 69,
 26, 26, 86, 86, 86, 26, 26, 86, 86, 86, 86, 86, 86, 86, 86, 86,
 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 26, 26, 26, 26, 26,
 26, 26, 26, 26, 26, 86, 86, 86, 86, 86, 86, 86, 26, 86, 26, 26,
 86, 26, 86, 86, 86, 86, 86, 86, 26, 26, 26, 86, 86, 86, 26, 26,
 86, 86, 86, 26, 26, 86, 86, 86, 86, 86, 86, 86, 26, 86, 26, 26,
 86, 26, 86, 86, 86, 86, 86, 86, 26, 26, 26, 86, 86, 86, 26, 26,
 86, 86, 86, 26, 26, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86,
 86, 86, 86, 86, 86, 86, 86, 86, 86, 26, 26, 26, 26, 26, 26, 26,
 26, 26, 26, 86, 86, 86, 86, 86, 86, 86, 26, 86, 26, 26, 86, 26,
 86, 86, 86, 86, 86, 86, 26, 26, 26, 86, 86, 70, 26, 26, 86, 86,
 86, 26, 26, 86, 86, 86, 86, 86, 86, 86, 26, 86, 26, 26, 86, 26,
 86, 86, 86, 86, 86, 86, 26, 26, 26, 86, 86, 70, 26, 26, 86, 86,
 86, 26, 26, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86,
 86, 86, 86, 86, 86, 86, 86, 26, 26, 26, 26, 26, 26, 26, 26, 26,
 26, 86, 86, 86, 86, 86, 86, 86, 26, 86, 26, 26, 86, 26, 86, 86,
 86, 86, 86, 86, 26, 26, 26, 86, 86, 86, 26, 26, 86, 86, 86, 26,
 26, 86, 86, 86, 86, 86, 86, 86, 26, 86, 26, 26, 86, 26, 86, 86,
 86, 86, 86, 86, 26, 26, 26, 86, 86, 86, 26, 26, 86, 86, 86, 26,
 26, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86,
 86, 86, 86, 86, 86, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 86,
 86, 86, 86, 86, 86, 86, 26, 86, 26, 26, 86, 26, 86, 86, 86, 86,
 86, 86, 26, 71, 26, 86, 86, 86, 26, 26, 86, 86, 86, 26, 26, 86,
 86, 86, 86, 86, 86, 86, 26, 86, 26, 26, 86, 26, 86, 86, 86, 86,
 86, 86, 26, 71, 26, 86, 86, 86, 26, 26, 86, 86, 86, 26, 26, 86,
 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86,
 86, 86, 86, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 86, 86, 86,
 86, 86, 86, 86, 26, 86, 26, 72, 86, 26, 86, 86, 86, 86, 86, 86,
 26, 26, 26, 86, 86, 86, 26, 26, 86, 86, 86, 26, 26, 86, 86, 86,
 86, 86, 86, 86, 26, 86, 26, 72, 86, 26, 86, 86, 86, 86, 86, 86,
 26, 26, 26, 86, 86, 86, 26, 26, 86, 86, 86, 26, 26, 86, 86, 86,
 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86,
 86, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 86, 86, 86, 86, 86,
 86, 86, 26, 86, 26, 26, 86, 26, 86, 86, 86, 86, 86, 86, 26, 26,
 26, 86, 86, 86, 26, 26, 86, 86, 86, 26, 26, 86, 86, 86, 86, 86,
 86, 86, 26, 86, 26, 26, 86, 26, 86, 86, 86, 86, 86, 86, 26, 26,
 26, 86, 86, 86, 26, 26, 86, 86, 86, 26, 26, 86, 86, 86, 86, 86,
 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 74, 86, 86,
 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86,
 26, 86, 26, 26, 86, 26, 86, 86, 86, 86, 86, 86, 26, 26, 26, 86,
 86, 86, 26, 26, 86, 86, 86, 26, 26, 86, 86, 86, 86, 86, 86, 86,
 26, 86, 26, 26, 86, 26, 86, 86, 86, 86, 86, 86, 26, 26, 26, 86,
 86, 86, 26, 26, 86, 86, 86, 26, 26, 86, 86, 86, 86, 86, 86, 86,
 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 75, 75, 75,
 75, 75, 75, 75, 75, 75, 75, 86, 86, 86, 86, 86, 86, 86, 26, 86,
 26, 26, 86, 26, 86, 86, 86, 86, 86, 86, 26, 26, 26, 86, 86, 86,
 26, 26, 86, 86, 86, 26, 26, 86, 86, 86, 86, 86, 86, 86, 26, 86,
 26, 26, 86, 26, 86, 86, 86, 86, 86, 86, 26, 26, 26, 86, 86, 86,
 26, 26, 86, 86, 86, 26, 26, 86, 86, 86, 86, 86, 86, 86, 86, 86,
 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 75, 75, 75, 75, 75,
 75, 75, 75, 75, 75, 86, 86, 86, 86, 86, 86, 86, 26, 86, 26, 26,
 86, 26, 86, 86, 86, 86, 86, 86, 26, 26, 26, 86, 86, 86, 26, 26,
 86, 86, 86, 26, 26, 86, 86, 86, 86, 86, 86, 86, 26, 86, 26, 26,
 86, 26, 86, 86, 86, 86, 86, 86, 26, 26, 26, 86, 86, 86, 26, 26,
 86, 86, 86, 26, 26, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86,
 86, 86, 86, 86, 86, 86, 86, 86, 86, 26, 26, 26, 26, 26, 26, 26,
 26, 26, 26, 86, 86, 86, 86, 86, 86, 86, 80, 86, 26, 26, 86, 26,
 86, 86, 86, 86, 86, 86, 26, 26, 79, 86, 86, 86, 26, 26, 86, 86,
 86, 26, 26, 86, 86, 86, 86, 86, 86, 86, 80, 86, 26, 26, 86, 26,
 86, 86, 86, 86, 86, 86, 26, 26, 79, 86, 86, 86, 26, 26, 86, 86,
 86, 26, 26, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86,
 86, 86, 86, 86, 86, 86, 86, 26, 26, 26, 26, 26, 26, 26, 26, 26,
 26, 86, 86, 86, 86, 86, 86, 86, 26, 86, 26, 26, 86, 26, 86, 86,
 86, 86, 86, 86, 26, 81, 26, 86, 86, 86, 26, 26, 86, 86, 86, 26,
 26, 86, 86, 86, 86, 86, 86, 86, 26, 86, 26, 26, 86, 26, 86, 86,
 86, 86, 86, 86, 26, 81, 26, 86, 86, 86, 26, 26, 86, 86, 86, 26,
 26, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86,
 86, 86, 86, 86, 86, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 86,
 86, 86, 86, 86, 86, 86, 26, 86, 26, 82, 86, 26, 86, 86, 86, 86,
 86, 86, 26, 26, 26, 86, 86, 86, 26, 26, 86, 86, 86, 26, 26, 86,
 86, 86, 86, 86, 86, 86, 26, 86, 26, 82, 86, 26, 86, 86, 86, 86,
 86, 86, 26, 26, 26, 86, 86, 86, 26, 26, 86, 86, 86, 26, 26, 86,
 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86,
 86, 86, 86, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 86, 86, 86,
 86, 86, 86, 86, 26, 86, 26, 26, 86, 26, 86, 86, 86, 86, 86, 86,
 26, 26, 26, 86, 86, 86, 26, 26, 86, 86, 86, 26, 26, 86, 86, 86,
 86, 86, 86, 86, 26, 86, 26, 26, 86, 26, 86, 86, 86, 86, 86, 86,
 26, 26, 26, 86, 86, 86, 26, 26, 86, 86, 86, 26, 26, 86, 86, 86,
 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86,
 86, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 86, 86, 86, 86, 86,
 86, 86, 26, 86, 26, 26, 86, 26, 86, 86, 86, 86, 86, 86, 26, 26,
 26, 86, 86, 84, 26, 83, 86, 86, 86, 26, 26, 86, 86, 86, 86, 86,
 86, 86, 26, 86, 26, 26, 86, 26, 86, 86, 86, 86, 86, 86, 26, 26,
 26, 86, 86, 84, 26, 83, 86, 86, 86, 26, 26, 86, 86, 86, 86, 86,
 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 26,
 26, 26, 26, 26, 26, 26, 26, 26, 26, 86, 86, 86, 86, 86, 86, 86,
 26, 86, 26, 26, 86, 26, 86, 86, 86, 86, 86, 86, 26, 26, 26, 86,
 86, 86, 26, 26, 86, 86, 86, 26, 26, 86, 86, 86, 86, 86, 86, 86,
 26, 86, 26, 26, 86, 26, 86, 86, 86, 86, 86, 86, 26, 26, 26, 86,
 86, 86, 26, 26, 86, 86, 86, 26, 26, 86, 86, 86, 86, 86, 86, 86,
 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 26, 26, 26,
 26, 26, 26, 26, 26, 26, 26, 86, 86, 86, 86, 86, 86, 86, 26, 86,
 26, 26, 86, 26, 86, 86, 86, 86, 86, 86, 26, 26, 26, 86, 86, 86,
 26, 26, 86, 86, 86, 26, 26, 86, 86, 86, 86, 86, 86, 86, 26, 86,
 26, 26, 86, 26, 86, 86, 86, 86, 86, 86, 26, 26, 26, 86, 86, 86,
 26, 26, 86, 86, 86, 26, 26, 86, 86, 0
);

type tableyy_check = array[0..5993] of yy_state_t;
var yy_check: ^tableyy_check;
const tblyy_check: tableyy_check = (
 $FF, $FF, $FF, $FF, $FF, $FF, $FF, $FF, $FF, 0, 0, $FF, $FF, 0, 27, 27,
 $FF, $FF, 27, $FF, $FF, $FF, $FF, $FF, $FF, $FF, $FF, $FF, $FF, $FF, $FF, $FF,
 0, 0, 0, $FF, 0, 27, $FF, 0, 0, 0, 0, 0, 2, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 76, $FF, 0, 0, 0, 16,
 14, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 15, 15, $FF, $FF, 0,
 $FF, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 26, 26, $FF, $FF,
 26, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, $FF, $FF, $FF, $FF, $FF,
 $FF, $FF, $FF, 26, 26, 26, $FF, 26, $FF, $FF, 26, 26, 26, 26, 26, $FF,
 26, $FF, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, $FF, $FF, 26,
 26, 26, $FF, $FF, 26, $FF, 26, 26, $FF, 26, $FF, $FF, $FF, $FF, $FF, $FF,
 26, 26, 26, $FF, $FF, $FF, 26, 26, $FF, $FF, $FF, 26, 26, $FF, $FF, $FF,
 $FF, $FF, $FF, $FF, 26, $FF, 26, 26, $FF, 26, 25, 25, $FF, $FF, 25, $FF,
 26, 26, 26, $FF, $FF, $FF, 26, 26, $FF, $FF, $FF, 26, 26, $FF, 26, $FF,
 $FF, 25, 25, 25, $FF, 25, $FF, $FF, 25, 25, 25, 25, 25, $FF, 25, $FF,
 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, $FF, $FF, 25, 25, 25,
 $FF, $FF, 25, $FF, 25, 25, 25, 25, $FF, $FF, $FF, $FF, $FF, $FF, 25, 25,
 25, $FF, $FF, $FF, 25, 25, $FF, $FF, $FF, 25, 25, $FF, $FF, $FF, $FF, $FF,
 $FF, $FF, 25, $FF, 25, 25, 25, 25, 28, 28, $FF, $FF, 28, $FF, 25, 25,
 25, $FF, $FF, $FF, 25, 25, $FF, $FF, $FF, 25, 25, $FF, 25, $FF, $FF, 28,
 28, 28, $FF, 28, $FF, $FF, 28, 28, 28, 28, 28, $FF, 28, $FF, 28, 28,
 28, 28, 28, 28, 28, 28, 28, 28, 28, $FF, $FF, 28, 28, 28, $FF, $FF,
 28, $FF, 28, 28, $FF, 28, $FF, $FF, $FF, $FF, $FF, $FF, 28, 28, 28, $FF,
 $FF, $FF, 28, 28, $FF, $FF, $FF, 28, 28, $FF, $FF, $FF, $FF, $FF, $FF, $FF,
 28, $FF, 28, 28, $FF, 28, 29, 29, $FF, $FF, 29, $FF, 28, 28, 28, $FF,
 $FF, $FF, 28, 28, $FF, $FF, $FF, 28, 28, $FF, 28, $FF, $FF, 29, 29, 29,
 $FF, 29, $FF, $FF, 29, 29, 29, 29, 29, $FF, 29, $FF, 29, 29, 29, 29,
 29, 29, 29, 29, 29, 29, 29, $FF, $FF, 29, 29, 29, $FF, $FF, 29, $FF,
 29, 29, $FF, 29, $FF, $FF, $FF, $FF, $FF, $FF, 29, 29, 29, $FF, $FF, 29,
 29, 29, $FF, $FF, $FF, 29, 29, $FF, $FF, $FF, $FF, $FF, $FF, $FF, 29, $FF,
 29, 29, $FF, 29, 30, 30, $FF, $FF, 30, $FF, 29, 29, 29, $FF, $FF, 29,
 29, 29, $FF, $FF, $FF, 29, 29, $FF, 29, $FF, $FF, 30, 30, 30, $FF, 30,
 $FF, $FF, 30, 30, 30, 30, 30, $FF, 30, $FF, 30, 30, 30, 30, 30, 30,
 30, 30, 30, 30, 30, $FF, $FF, 30, 30, 30, $FF, $FF, 30, $FF, 30, 30,
 $FF, 30, $FF, $FF, $FF, $FF, $FF, $FF, 30, 30, 30, $FF, $FF, $FF, 30, 30,
 $FF, $FF, $FF, 30, 30, $FF, $FF, $FF, $FF, $FF, $FF, $FF, 30, $FF, 30, 30,
 $FF, 30, 24, 24, $FF, $FF, 24, $FF, 30, 30, 30, $FF, $FF, $FF, 30, 30,
 $FF, $FF, $FF, 30, 30, $FF, 30, $FF, $FF, 24, 24, 24, $FF, 24, $FF, $FF,
 24, 24, 24, 24, 24, $FF, 24, $FF, 24, 24, 24, 24, 24, 24, 24, 24,
 24, 24, 24, $FF, $FF, 24, 24, 24, $FF, $FF, 24, $FF, 24, 24, $FF, 24,
 $FF, $FF, $FF, $FF, $FF, $FF, 24, 24, 24, $FF, $FF, $FF, 24, 24, $FF, $FF,
 $FF, 24, 24, $FF, $FF, $FF, $FF, $FF, $FF, $FF, 24, $FF, 24, 24, $FF, 24,
 31, 31, $FF, $FF, 31, $FF, 24, 24, 24, $FF, $FF, $FF, 24, 24, $FF, $FF,
 $FF, 24, 24, $FF, 24, $FF, $FF, 31, 31, 31, $FF, 31, $FF, $FF, 31, 31,
 31, 31, 31, $FF, 31, $FF, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31,
 31, $FF, $FF, 31, 31, 31, $FF, $FF, 31, $FF, 31, 31, $FF, 31, $FF, $FF,
 $FF, $FF, $FF, $FF, 31, 31, 31, $FF, $FF, $FF, 31, 31, $FF, $FF, $FF, 31,
 31, $FF, $FF, $FF, $FF, $FF, $FF, $FF, 31, $FF, 31, 31, $FF, 31, 33, 33,
 $FF, $FF, 33, $FF, 31, 31, 31, $FF, $FF, $FF, 31, 31, $FF, $FF, $FF, 31,
 31, $FF, 31, $FF, $FF, 33, 33, 33, $FF, 33, $FF, $FF, 33, 33, 33, 33,
 33, $FF, 33, $FF, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, $FF,
 $FF, 33, 33, 33, $FF, $FF, 33, $FF, 33, 33, $FF, 33, $FF, $FF, $FF, $FF,
 $FF, $FF, 33, 33, 33, $FF, $FF, $FF, 33, 33, $FF, $FF, $FF, 33, 33, $FF,
 $FF, $FF, $FF, $FF, $FF, $FF, 33, $FF, 33, 33, $FF, 33, 34, 34, $FF, $FF,
 34, $FF, 33, 33, 33, $FF, $FF, $FF, 33, 33, $FF, $FF, $FF, 33, 33, $FF,
 33, $FF, $FF, 34, 34, 34, $FF, 34, $FF, $FF, 34, 34, 34, 34, 34, $FF,
 34, $FF, 34, 34, 34, 34, 34, 34, 34, 34, 34, 34, 34, $FF, $FF, 34,
 34, 34, $FF, $FF, 34, $FF, 34, 34, $FF, 34, $FF, 34, $FF, $FF, $FF, $FF,
 34, 34, 34, $FF, $FF, $FF, 34, 34, $FF, $FF, $FF, 34, 34, $FF, $FF, $FF,
 $FF, $FF, $FF, $FF, 34, $FF, 34, 34, $FF, 34, $FF, 34, $FF, $FF, $FF, $FF,
 34, 34, 34, $FF, 35, 35, 34, 34, 35, $FF, $FF, 34, 34, $FF, 34, 7,
 7, 7, 7, 7, 7, 7, 7, 7, 7, $FF, $FF, 35, 35, 35, $FF, 35,
 $FF, $FF, 35, 35, 35, 35, 35, $FF, 35, $FF, 35, 35, 35, 35, 35, 35,
 35, 35, 35, 35, 35, $FF, $FF, 35, 35, 35, $FF, $FF, 35, $FF, 35, 35,
 $FF, 35, $FF, $FF, $FF, $FF, $FF, $FF, 35, 35, 35, $FF, $FF, $FF, 35, 35,
 $FF, $FF, $FF, 35, 35, $FF, $FF, $FF, $FF, $FF, $FF, $FF, 35, $FF, 35, 35,
 $FF, 35, 32, 32, $FF, $FF, 32, $FF, 35, 35, 35, $FF, $FF, $FF, 35, 35,
 $FF, $FF, $FF, 35, 35, $FF, 35, $FF, $FF, 32, 32, 32, $FF, 32, $FF, $FF,
 32, 32, 32, 32, 32, $FF, 32, $FF, 32, 32, 32, 32, 32, 32, 32, 32,
 32, 32, 32, $FF, $FF, 32, 32, 32, $FF, $FF, 32, $FF, 32, 32, $FF, 32,
 $FF, $FF, $FF, $FF, $FF, $FF, 32, 32, 32, $FF, $FF, $FF, 32, 32, $FF, $FF,
 $FF, 32, 32, $FF, $FF, $FF, $FF, $FF, $FF, $FF, 32, $FF, 32, 32, $FF, 32,
 23, 23, $FF, $FF, 23, $FF, 32, 32, 32, $FF, $FF, $FF, 32, 32, $FF, $FF,
 $FF, 32, 32, $FF, 32, $FF, $FF, 23, 23, 23, $FF, 23, $FF, $FF, 23, 23,
 23, 23, 23, $FF, 23, $FF, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23,
 23, $FF, $FF, 23, 23, 23, $FF, $FF, 23, $FF, 23, 23, $FF, 23, $FF, $FF,
 23, $FF, $FF, $FF, 23, 23, 23, $FF, $FF, $FF, 23, 23, $FF, $FF, $FF, 23,
 23, $FF, $FF, $FF, $FF, $FF, $FF, $FF, 23, $FF, 23, 23, $FF, 23, 37, 37,
 23, $FF, 37, $FF, 23, 23, 23, $FF, $FF, $FF, 23, 23, $FF, $FF, $FF, 23,
 23, $FF, 23, $FF, $FF, 37, 37, 37, $FF, 37, $FF, $FF, 37, 37, 37, 37,
 37, $FF, 37, $FF, 37, 37, 37, 37, 37, 37, 37, 37, 37, 37, 37, $FF,
 $FF, 37, 37, 37, $FF, $FF, 37, $FF, 37, 37, $FF, 37, $FF, $FF, $FF, $FF,
 $FF, $FF, 37, 37, 37, $FF, $FF, $FF, 37, 37, $FF, $FF, $FF, 37, 37, $FF,
 $FF, $FF, $FF, $FF, $FF, $FF, 37, $FF, 37, 37, $FF, 37, 38, 38, $FF, $FF,
 38, $FF, 37, 37, 37, $FF, $FF, $FF, 37, 37, $FF, $FF, $FF, 37, 37, $FF,
 37, $FF, $FF, 38, 38, 38, $FF, 38, $FF, $FF, 38, 38, 38, 38, 38, $FF,
 38, $FF, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, $FF, $FF, 38,
 38, 38, $FF, $FF, 38, $FF, 38, 38, $FF, 38, $FF, $FF, $FF, $FF, $FF, $FF,
 38, 38, 38, $FF, $FF, $FF, 38, 38, $FF, $FF, $FF, 38, 38, $FF, $FF, $FF,
 $FF, $FF, $FF, $FF, 38, $FF, 38, 38, $FF, 38, 36, 36, $FF, $FF, 36, $FF,
 38, 38, 38, $FF, $FF, $FF, 38, 38, $FF, $FF, $FF, 38, 38, $FF, 38, $FF,
 $FF, 36, 36, 36, $FF, 36, $FF, $FF, 36, 36, 36, 36, 36, $FF, 36, $FF,
 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, $FF, $FF, 36, 36, 36,
 $FF, $FF, 36, $FF, 36, 36, $FF, 36, $FF, $FF, $FF, $FF, $FF, $FF, 36, 36,
 36, $FF, $FF, $FF, 36, 36, $FF, 36, $FF, 36, 36, $FF, $FF, $FF, $FF, $FF,
 $FF, $FF, 36, $FF, 36, 36, $FF, 36, 39, 39, $FF, $FF, 39, $FF, 36, 36,
 36, $FF, $FF, $FF, 36, 36, $FF, 36, $FF, 36, 36, $FF, 36, $FF, $FF, 39,
 39, 39, $FF, 39, $FF, $FF, 39, 39, 39, 39, 39, $FF, 39, $FF, 39, 39,
 39, 39, 39, 39, 39, 39, 39, 39, 39, $FF, $FF, 39, 39, 39, $FF, $FF,
 39, $FF, 39, 39, $FF, 39, $FF, $FF, $FF, $FF, $FF, $FF, 39, 39, 39, $FF,
 $FF, $FF, 39, 39, $FF, $FF, $FF, 39, 39, $FF, $FF, $FF, $FF, $FF, $FF, $FF,
 39, $FF, 39, 39, $FF, 39, 20, 20, $FF, $FF, 20, $FF, 39, 39, 39, $FF,
 $FF, $FF, 39, 39, $FF, $FF, $FF, 39, 39, $FF, 39, $FF, $FF, 20, 20, 20,
 $FF, 20, $FF, $FF, 20, 20, 20, 20, 20, $FF, 20, $FF, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, $FF, $FF, 20, 20, 20, $FF, $FF, 20, $FF,
 20, 20, $FF, 20, $FF, $FF, $FF, $FF, $FF, $FF, 20, 20, 20, $FF, $FF, $FF,
 20, 20, $FF, $FF, $FF, 20, 20, $FF, $FF, $FF, $FF, $FF, $FF, $FF, 20, $FF,
 20, 20, $FF, 20, 40, 40, $FF, $FF, 40, $FF, 20, 20, 20, $FF, $FF, $FF,
 20, 20, $FF, $FF, $FF, 20, 20, $FF, 20, $FF, $FF, 40, 40, 40, $FF, 40,
 $FF, $FF, 40, 40, 40, 40, 40, $FF, 40, $FF, 40, 40, 40, 40, 40, 40,
 40, 40, 40, 40, 40, $FF, $FF, 40, 40, 40, $FF, $FF, 40, $FF, 40, 40,
 $FF, 40, $FF, $FF, $FF, $FF, $FF, 40, 40, 40, 40, $FF, $FF, $FF, 40, 40,
 $FF, $FF, $FF, 40, 40, $FF, $FF, $FF, $FF, $FF, $FF, $FF, 40, $FF, 40, 40,
 $FF, 40, 41, 41, $FF, $FF, 41, 40, 40, 40, 40, $FF, $FF, $FF, 40, 40,
 $FF, $FF, $FF, 40, 40, $FF, 40, $FF, $FF, 41, 41, 41, $FF, 41, $FF, $FF,
 41, 41, 41, 41, 41, $FF, 41, $FF, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, $FF, $FF, 41, 41, 41, $FF, $FF, 41, $FF, 41, 41, $FF, 41,
 $FF, $FF, $FF, $FF, $FF, $FF, 41, 41, 41, $FF, $FF, $FF, 41, 41, $FF, $FF,
 $FF, 41, 41, $FF, $FF, $FF, $FF, $FF, $FF, $FF, 41, $FF, 41, 41, $FF, 41,
 42, 42, $FF, $FF, 42, $FF, 41, 41, 41, $FF, $FF, $FF, 41, 41, $FF, $FF,
 $FF, 41, 41, $FF, 41, $FF, $FF, 42, 42, 42, $FF, 42, $FF, $FF, 42, 42,
 42, 42, 42, $FF, 42, $FF, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42,
 42, $FF, $FF, 42, 42, 42, $FF, $FF, 42, $FF, 42, 42, 42, 42, $FF, $FF,
 $FF, $FF, $FF, $FF, 42, 42, 42, $FF, $FF, $FF, 42, 42, $FF, $FF, $FF, 42,
 42, $FF, $FF, $FF, $FF, $FF, $FF, $FF, 42, $FF, 42, 42, 42, 42, 43, 43,
 $FF, $FF, 43, $FF, 42, 42, 42, $FF, $FF, $FF, 42, 42, $FF, $FF, $FF, 42,
 42, $FF, 42, $FF, $FF, 43, 43, 43, $FF, 43, $FF, $FF, 43, 43, 43, 43,
 43, $FF, 43, $FF, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, $FF,
 $FF, 43, 43, 43, $FF, $FF, 43, $FF, 43, 43, $FF, 43, $FF, $FF, $FF, $FF,
 $FF, $FF, 43, 43, 43, $FF, $FF, $FF, 43, 43, $FF, $FF, $FF, 43, 43, $FF,
 $FF, $FF, $FF, $FF, $FF, $FF, 43, $FF, 43, 43, $FF, 43, 19, 19, $FF, $FF,
 19, $FF, 43, 43, 43, $FF, $FF, $FF, 43, 43, $FF, $FF, $FF, 43, 43, $FF,
 43, $FF, $FF, 19, 19, 19, $FF, 19, $FF, $FF, 19, 19, 19, 19, 19, $FF,
 19, $FF, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, $FF, $FF, 19,
 19, 19, $FF, $FF, 19, $FF, 19, 19, $FF, 19, $FF, $FF, $FF, $FF, $FF, $FF,
 19, 19, 19, $FF, $FF, 19, 19, 19, $FF, $FF, $FF, 19, 19, $FF, $FF, $FF,
 $FF, $FF, $FF, $FF, 19, $FF, 19, 19, $FF, 19, 44, 44, $FF, $FF, 44, $FF,
 19, 19, 19, $FF, $FF, 19, 19, 19, $FF, $FF, $FF, 19, 19, $FF, 19, $FF,
 $FF, 44, 44, 44, $FF, 44, $FF, $FF, 44, 44, 44, 44, 44, $FF, 44, $FF,
 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, $FF, $FF, 44, 44, 44,
 $FF, $FF, 44, $FF, 44, 44, $FF, 44, $FF, $FF, $FF, $FF, $FF, $FF, 44, 44,
 44, $FF, $FF, $FF, 44, 44, 44, $FF, $FF, 44, 44, $FF, $FF, $FF, $FF, $FF,
 $FF, $FF, 44, $FF, 44, 44, $FF, 44, 45, 45, $FF, $FF, 45, $FF, 44, 44,
 44, $FF, $FF, $FF, 44, 44, 44, $FF, $FF, 44, 44, $FF, 44, $FF, $FF, 45,
 45, 45, $FF, 45, $FF, $FF, 45, 45, 45, 45, 45, $FF, 45, $FF, 45, 45,
 45, 45, 45, 45, 45, 45, 45, 45, 45, $FF, $FF, 45, 45, 45, $FF, $FF,
 45, $FF, 45, 45, 45, 45, $FF, $FF, $FF, $FF, $FF, $FF, 45, 45, 45, $FF,
 $FF, $FF, 45, 45, $FF, $FF, $FF, 45, 45, $FF, $FF, $FF, $FF, $FF, $FF, $FF,
 45, $FF, 45, 45, 45, 45, 46, 46, $FF, $FF, 46, $FF, 45, 45, 45, $FF,
 $FF, $FF, 45, 45, $FF, $FF, $FF, 45, 45, $FF, 45, $FF, $FF, 46, 46, 46,
 $FF, 46, $FF, $FF, 46, 46, 46, 46, 46, $FF, 46, $FF, 46, 46, 46, 46,
 46, 46, 46, 46, 46, 46, 46, $FF, $FF, 46, 46, 46, $FF, $FF, 46, $FF,
 46, 46, $FF, 46, $FF, $FF, $FF, $FF, $FF, $FF, 46, 46, 46, $FF, $FF, $FF,
 46, 46, $FF, $FF, $FF, 46, 46, $FF, $FF, $FF, $FF, $FF, $FF, $FF, 46, $FF,
 46, 46, $FF, 46, 18, 18, $FF, $FF, 18, $FF, 46, 46, 46, $FF, $FF, $FF,
 46, 46, $FF, $FF, $FF, 46, 46, $FF, 46, $FF, $FF, 18, 18, 18, $FF, 18,
 $FF, $FF, 18, 18, 18, 18, 18, $FF, 18, $FF, 18, 18, 18, 18, 18, 18,
 18, 18, 18, 18, 18, $FF, $FF, 18, 18, 18, $FF, $FF, 18, $FF, 18, 18,
 $FF, 18, $FF, $FF, $FF, $FF, $FF, $FF, 18, 18, 18, $FF, $FF, $FF, 18, 18,
 $FF, $FF, $FF, 18, 18, $FF, $FF, $FF, $FF, $FF, $FF, $FF, 18, $FF, 18, 18,
 $FF, 18, 47, 47, $FF, $FF, 47, $FF, 18, 18, 18, $FF, $FF, $FF, 18, 18,
 $FF, $FF, $FF, 18, 18, $FF, 18, $FF, $FF, 47, 47, 47, $FF, 47, $FF, $FF,
 47, 47, 47, 47, 47, $FF, 47, $FF, 47, 47, 47, 47, 47, 47, 47, 47,
 47, 47, 47, $FF, $FF, 47, 47, 47, $FF, $FF, 47, $FF, 47, 47, $FF, 47,
 $FF, $FF, $FF, $FF, $FF, $FF, 47, 47, 47, $FF, $FF, $FF, 47, 47, $FF, $FF,
 $FF, 47, 47, $FF, $FF, $FF, $FF, $FF, $FF, $FF, 47, $FF, 47, 47, $FF, 47,
 48, 48, $FF, $FF, 48, $FF, 47, 47, 47, $FF, $FF, $FF, 47, 47, $FF, $FF,
 $FF, 47, 47, $FF, 47, $FF, $FF, 48, 48, 48, $FF, 48, $FF, $FF, 48, 48,
 48, 48, 48, $FF, 48, $FF, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
 48, $FF, $FF, 48, 48, 48, $FF, $FF, 48, $FF, 48, 48, $FF, 48, $FF, $FF,
 $FF, $FF, $FF, $FF, 48, 48, 48, $FF, $FF, $FF, 48, 48, $FF, $FF, $FF, 48,
 48, $FF, $FF, $FF, $FF, $FF, $FF, $FF, 48, $FF, 48, 48, $FF, 48, 49, 49,
 $FF, $FF, 49, $FF, 48, 48, 48, $FF, $FF, $FF, 48, 48, $FF, $FF, $FF, 48,
 48, $FF, 48, $FF, $FF, 49, 49, 49, $FF, 49, $FF, $FF, 49, 49, 49, 49,
 49, $FF, 49, $FF, 49, 49, 49, 49, 49, 49, 49, 49, 49, 49, 49, $FF,
 $FF, 49, 49, 49, $FF, $FF, 49, $FF, 49, 49, $FF, 49, $FF, $FF, $FF, $FF,
 $FF, $FF, 49, 49, 49, $FF, $FF, $FF, 49, 49, $FF, $FF, $FF, 49, 49, $FF,
 $FF, $FF, $FF, $FF, $FF, $FF, 49, $FF, 49, 49, $FF, 49, 50, 50, $FF, $FF,
 50, $FF, 49, 49, 49, $FF, $FF, $FF, 49, 49, $FF, $FF, $FF, 49, 49, $FF,
 49, $FF, $FF, 50, 50, 50, $FF, 50, $FF, $FF, 50, 50, 50, 50, 50, $FF,
 50, $FF, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, $FF, $FF, 50,
 50, 50, $FF, $FF, 50, $FF, 50, 50, $FF, 50, $FF, $FF, 50, $FF, $FF, $FF,
 50, 50, 50, $FF, $FF, $FF, 50, 50, $FF, $FF, $FF, 50, 50, $FF, $FF, $FF,
 $FF, $FF, $FF, $FF, 50, $FF, 50, 50, $FF, 50, 51, 51, 50, $FF, 51, $FF,
 50, 50, 50, $FF, $FF, $FF, 50, 50, $FF, $FF, $FF, 50, 50, $FF, 50, $FF,
 $FF, 51, 51, 51, $FF, 51, $FF, $FF, 51, 51, 51, 51, 51, $FF, 51, $FF,
 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, $FF, $FF, 51, 51, 51,
 $FF, $FF, 51, $FF, 51, 51, $FF, 51, $FF, $FF, $FF, $FF, $FF, $FF, 51, 51,
 51, $FF, $FF, $FF, 51, 51, $FF, $FF, $FF, 51, 51, $FF, $FF, $FF, $FF, $FF,
 $FF, $FF, 51, $FF, 51, 51, $FF, 51, 52, 52, $FF, $FF, 52, $FF, 51, 51,
 51, $FF, $FF, $FF, 51, 51, $FF, $FF, $FF, 51, 51, $FF, 51, $FF, $FF, 52,
 52, 52, $FF, 52, $FF, $FF, 52, 52, 52, 52, 52, $FF, 52, $FF, 52, 52,
 52, 52, 52, 52, 52, 52, 52, 52, 52, $FF, $FF, 52, 52, 52, $FF, $FF,
 52, $FF, 52, 52, $FF, 52, $FF, $FF, $FF, $FF, $FF, $FF, 52, 52, 52, $FF,
 $FF, $FF, 52, 52, $FF, $FF, $FF, 52, 52, $FF, $FF, $FF, $FF, $FF, $FF, $FF,
 52, $FF, 52, 52, $FF, 52, 53, 53, $FF, $FF, 53, $FF, 52, 52, 52, $FF,
 $FF, $FF, 52, 52, $FF, $FF, $FF, 52, 52, $FF, 52, $FF, $FF, 53, 53, 53,
 $FF, 53, $FF, $FF, 53, 53, 53, 53, 53, $FF, 53, $FF, 53, 53, 53, 53,
 53, 53, 53, 53, 53, 53, 53, $FF, $FF, 53, 53, 53, $FF, $FF, 53, $FF,
 53, 53, $FF, 53, $FF, $FF, $FF, $FF, $FF, $FF, 53, 53, 53, $FF, $FF, $FF,
 53, 53, $FF, $FF, $FF, 53, 53, $FF, $FF, $FF, $FF, $FF, $FF, $FF, 53, $FF,
 53, 53, $FF, 53, 17, 17, $FF, $FF, 17, $FF, 53, 53, 53, $FF, $FF, $FF,
 53, 53, $FF, $FF, $FF, 53, 53, $FF, 53, $FF, $FF, 17, 17, 17, $FF, 17,
 $FF, $FF, 17, 17, 17, 17, 17, $FF, 17, $FF, 17, 17, 17, 17, 17, 17,
 17, 17, 17, 17, 17, $FF, $FF, 17, 17, 17, $FF, $FF, 17, $FF, 17, 17,
 $FF, 17, $FF, $FF, $FF, $FF, $FF, $FF, 17, 17, 17, $FF, $FF, $FF, 17, 17,
 $FF, $FF, $FF, 17, 17, $FF, $FF, $FF, $FF, $FF, $FF, $FF, 17, $FF, 17, 17,
 $FF, 17, 54, 54, $FF, $FF, 54, $FF, 17, 17, 17, $FF, $FF, $FF, 17, 17,
 $FF, $FF, $FF, 17, 17, $FF, 17, $FF, $FF, 54, 54, 54, $FF, 54, $FF, $FF,
 54, 54, 54, 54, 54, $FF, 54, $FF, 54, 54, 54, 54, 54, 54, 54, 54,
 54, 54, 54, $FF, $FF, 54, 54, 54, $FF, $FF, 54, $FF, 54, 54, $FF, 54,
 $FF, $FF, $FF, $FF, $FF, $FF, 54, 54, 54, $FF, $FF, $FF, 54, 54, $FF, $FF,
 $FF, 54, 54, $FF, $FF, $FF, $FF, $FF, $FF, $FF, 54, $FF, 54, 54, $FF, 54,
 55, 55, $FF, $FF, 55, $FF, 54, 54, 54, $FF, $FF, $FF, 54, 54, $FF, $FF,
 $FF, 54, 54, $FF, 54, $FF, $FF, 55, 55, 55, $FF, 55, $FF, $FF, 55, 55,
 55, 55, 55, $FF, 55, $FF, 55, 55, 55, 55, 55, 55, 55, 55, 55, 55,
 55, $FF, $FF, 55, 55, 55, $FF, $FF, 55, $FF, 55, 55, $FF, 55, $FF, $FF,
 $FF, $FF, $FF, $FF, 55, 55, 55, $FF, $FF, 55, 55, 55, $FF, $FF, $FF, 55,
 55, $FF, $FF, $FF, $FF, $FF, $FF, $FF, 55, $FF, 55, 55, $FF, 55, 56, 56,
 $FF, $FF, 56, $FF, 55, 55, 55, $FF, $FF, 55, 55, 55, $FF, $FF, $FF, 55,
 55, $FF, 55, $FF, $FF, 56, 56, 56, $FF, 56, $FF, $FF, 56, 56, 56, 56,
 56, $FF, 56, $FF, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, $FF,
 $FF, 56, 56, 56, $FF, $FF, 56, $FF, 56, 56, $FF, 56, $FF, $FF, $FF, $FF,
 $FF, $FF, 56, 56, 56, $FF, $FF, $FF, 56, 56, $FF, $FF, $FF, 56, 56, $FF,
 $FF, $FF, $FF, $FF, $FF, $FF, 56, $FF, 56, 56, $FF, 56, 57, 57, $FF, $FF,
 57, $FF, 56, 56, 56, $FF, $FF, $FF, 56, 56, $FF, $FF, $FF, 56, 56, $FF,
 56, $FF, $FF, 57, 57, 57, $FF, 57, $FF, $FF, 57, 57, 57, 57, 57, $FF,
 57, $FF, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, $FF, $FF, 57,
 57, 57, $FF, $FF, 57, $FF, 57, 57, $FF, 57, $FF, $FF, $FF, $FF, $FF, $FF,
 57, 57, 57, $FF, $FF, $FF, 57, 57, $FF, $FF, $FF, 57, 57, $FF, $FF, $FF,
 $FF, $FF, $FF, $FF, 57, $FF, 57, 57, $FF, 57, 58, 58, $FF, $FF, 58, $FF,
 57, 57, 57, $FF, $FF, $FF, 57, 57, $FF, $FF, $FF, 57, 57, $FF, 57, $FF,
 $FF, 58, 58, 58, $FF, 58, $FF, $FF, 58, 58, 58, 58, 58, $FF, 58, $FF,
 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, $FF, $FF, 58, 58, 58,
 $FF, $FF, 58, $FF, 58, 58, $FF, 58, $FF, $FF, $FF, $FF, $FF, $FF, 58, 58,
 58, $FF, $FF, $FF, 58, 58, $FF, $FF, $FF, 58, 58, $FF, $FF, $FF, $FF, $FF,
 58, $FF, 58, $FF, 58, 58, $FF, 58, 59, 59, $FF, $FF, 59, $FF, 58, 58,
 58, $FF, $FF, $FF, 58, 58, $FF, $FF, $FF, 58, 58, $FF, 58, $FF, $FF, 59,
 59, 59, $FF, 59, $FF, $FF, 59, 59, 59, 59, 59, $FF, 59, $FF, 59, 59,
 59, 59, 59, 59, 59, 59, 59, 59, 59, $FF, $FF, 59, 59, 59, $FF, $FF,
 59, $FF, 59, 59, $FF, 59, $FF, $FF, $FF, $FF, $FF, $FF, 59, 59, 59, $FF,
 $FF, $FF, 59, 59, $FF, $FF, 59, 59, 59, $FF, $FF, $FF, $FF, $FF, $FF, $FF,
 59, $FF, 59, 59, $FF, 59, 60, 60, $FF, $FF, 60, $FF, 59, 59, 59, $FF,
 $FF, $FF, 59, 59, $FF, $FF, 59, 59, 59, $FF, 59, $FF, $FF, 60, 60, 60,
 $FF, 60, $FF, $FF, 60, 60, 60, 60, 60, $FF, 60, $FF, 60, 60, 60, 60,
 60, 60, 60, 60, 60, 60, 60, $FF, $FF, 60, 60, 60, $FF, $FF, 60, $FF,
 60, 60, $FF, 60, $FF, $FF, 60, $FF, $FF, $FF, 60, 60, 60, $FF, $FF, $FF,
 60, 60, $FF, $FF, $FF, 60, 60, $FF, $FF, $FF, $FF, $FF, $FF, $FF, 60, $FF,
 60, 60, $FF, 60, 61, 61, 60, $FF, 61, $FF, 60, 60, 60, $FF, $FF, $FF,
 60, 60, $FF, $FF, $FF, 60, 60, $FF, 60, $FF, $FF, 61, 61, 61, $FF, 61,
 $FF, $FF, 61, 61, 61, 61, 61, $FF, 61, $FF, 61, 61, 61, 61, 61, 61,
 61, 61, 61, 61, 61, $FF, $FF, 61, 61, 61, $FF, $FF, 61, $FF, 61, 61,
 $FF, 61, $FF, $FF, $FF, $FF, $FF, $FF, 61, 61, 61, $FF, $FF, $FF, 61, 61,
 $FF, $FF, $FF, 61, 61, $FF, $FF, $FF, $FF, $FF, $FF, $FF, 61, $FF, 61, 61,
 $FF, 61, 62, 62, $FF, $FF, 62, $FF, 61, 61, 61, $FF, $FF, $FF, 61, 61,
 $FF, $FF, $FF, 61, 61, $FF, 61, $FF, $FF, 62, 62, 62, $FF, 62, $FF, $FF,
 62, 62, 62, 62, 62, $FF, 62, $FF, 62, 62, 62, 62, 62, 62, 62, 62,
 62, 62, 62, $FF, $FF, 62, 62, 62, $FF, $FF, 62, $FF, 62, 62, $FF, 62,
 $FF, 62, $FF, $FF, $FF, $FF, 62, 62, 62, $FF, $FF, $FF, 62, 62, $FF, $FF,
 $FF, 62, 62, $FF, $FF, $FF, $FF, $FF, $FF, $FF, 62, $FF, 62, 62, $FF, 62,
 $FF, 62, $FF, $FF, $FF, $FF, 62, 62, 62, $FF, 63, 63, 62, 62, 63, $FF,
 $FF, 62, 62, $FF, 62, 77, 77, 77, 77, 77, 77, 77, 77, 77, 77, $FF,
 $FF, 63, 63, 63, $FF, 63, $FF, $FF, 63, 63, 63, 63, 63, $FF, 63, $FF,
 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, $FF, $FF, 63, 63, 63,
 $FF, $FF, 63, $FF, 63, 63, $FF, 63, $FF, $FF, $FF, $FF, $FF, $FF, 63, 63,
 63, $FF, $FF, $FF, 63, 63, $FF, $FF, $FF, 63, 63, $FF, $FF, $FF, $FF, $FF,
 $FF, $FF, 63, $FF, 63, 63, $FF, 63, 12, 12, $FF, $FF, 12, $FF, 63, 63,
 63, $FF, $FF, $FF, 63, 63, $FF, $FF, $FF, 63, 63, $FF, 63, $FF, $FF, 12,
 12, 12, $FF, 12, $FF, $FF, 12, 12, 12, 12, 12, $FF, 12, $FF, 12, 12,
 12, 12, 12, 12, 12, 12, 12, 12, 12, $FF, $FF, 12, 12, 12, $FF, $FF,
 12, $FF, 12, 12, $FF, 12, $FF, $FF, $FF, $FF, $FF, $FF, 12, 12, 12, $FF,
 $FF, $FF, 12, 12, $FF, $FF, $FF, 12, 12, $FF, $FF, $FF, $FF, $FF, $FF, $FF,
 12, $FF, 12, 12, $FF, 12, 68, 68, $FF, $FF, 68, $FF, 12, 12, 12, $FF,
 $FF, $FF, 12, 12, $FF, $FF, $FF, 12, 12, $FF, 12, $FF, $FF, 68, 68, 68,
 $FF, 68, $FF, $FF, 68, 68, 68, 68, 68, $FF, 68, $FF, 68, 68, 68, 68,
 68, 68, 68, 68, 68, 68, 68, $FF, $FF, 68, 68, 68, $FF, $FF, 68, $FF,
 68, 68, $FF, 68, $FF, $FF, $FF, $FF, $FF, $FF, 68, 68, 68, $FF, $FF, 68,
 68, 68, $FF, $FF, $FF, 68, 68, $FF, $FF, $FF, $FF, $FF, $FF, $FF, 68, $FF,
 68, 68, $FF, 68, 69, 69, $FF, $FF, 69, $FF, 68, 68, 68, $FF, $FF, 68,
 68, 68, $FF, $FF, $FF, 68, 68, $FF, 68, $FF, $FF, 69, 69, 69, $FF, 69,
 $FF, $FF, 69, 69, 69, 69, 69, $FF, 69, $FF, 69, 69, 69, 69, 69, 69,
 69, 69, 69, 69, 69, $FF, $FF, 69, 69, 69, $FF, $FF, 69, $FF, 69, 69,
 $FF, 69, $FF, $FF, $FF, $FF, $FF, $FF, 69, 69, 69, $FF, $FF, $FF, 69, 69,
 $FF, $FF, $FF, 69, 69, $FF, $FF, $FF, $FF, $FF, $FF, $FF, 69, $FF, 69, 69,
 $FF, 69, 11, 11, $FF, $FF, 11, $FF, 69, 69, 69, $FF, $FF, $FF, 69, 69,
 $FF, $FF, $FF, 69, 69, $FF, 69, $FF, $FF, 11, 11, 11, $FF, 11, $FF, $FF,
 11, 11, 11, 11, 11, $FF, 11, $FF, 11, 11, 11, 11, 11, 11, 11, 11,
 11, 11, 11, $FF, $FF, 11, 11, 11, $FF, $FF, 11, $FF, 11, 11, $FF, 11,
 $FF, $FF, $FF, $FF, $FF, $FF, 11, 11, 11, $FF, $FF, 11, 11, 11, $FF, $FF,
 $FF, 11, 11, $FF, $FF, $FF, $FF, $FF, $FF, $FF, 11, $FF, 11, 11, $FF, 11,
 70, 70, $FF, $FF, 70, $FF, 11, 11, 11, $FF, $FF, 11, 11, 11, $FF, $FF,
 $FF, 11, 11, $FF, 11, $FF, $FF, 70, 70, 70, $FF, 70, $FF, $FF, 70, 70,
 70, 70, 70, $FF, 70, $FF, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70,
 70, $FF, $FF, 70, 70, 70, $FF, $FF, 70, $FF, 70, 70, $FF, 70, $FF, $FF,
 $FF, $FF, $FF, $FF, 70, 70, 70, $FF, $FF, $FF, 70, 70, $FF, $FF, $FF, 70,
 70, $FF, $FF, $FF, $FF, $FF, $FF, $FF, 70, $FF, 70, 70, $FF, 70, 10, 10,
 $FF, $FF, 10, $FF, 70, 70, 70, $FF, $FF, $FF, 70, 70, $FF, $FF, $FF, 70,
 70, $FF, 70, $FF, $FF, 10, 10, 10, $FF, 10, $FF, $FF, 10, 10, 10, 10,
 10, $FF, 10, $FF, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, $FF,
 $FF, 10, 10, 10, $FF, $FF, 10, $FF, 10, 10, $FF, 10, $FF, $FF, $FF, $FF,
 $FF, $FF, 10, 10, 10, $FF, $FF, $FF, 10, 10, $FF, $FF, $FF, 10, 10, $FF,
 $FF, $FF, $FF, $FF, $FF, $FF, 10, $FF, 10, 10, $FF, 10, 71, 71, $FF, $FF,
 71, $FF, 10, 10, 10, $FF, $FF, $FF, 10, 10, $FF, $FF, $FF, 10, 10, $FF,
 10, $FF, $FF, 71, 71, 71, $FF, 71, $FF, $FF, 71, 71, 71, 71, 71, $FF,
 71, $FF, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, $FF, $FF, 71,
 71, 71, $FF, $FF, 71, $FF, 71, 71, $FF, 71, $FF, $FF, $FF, $FF, $FF, $FF,
 71, 71, 71, $FF, $FF, $FF, 71, 71, $FF, $FF, $FF, 71, 71, $FF, $FF, $FF,
 $FF, $FF, $FF, $FF, 71, $FF, 71, 71, $FF, 71, 72, 72, $FF, $FF, 72, $FF,
 71, 71, 71, $FF, $FF, $FF, 71, 71, $FF, $FF, $FF, 71, 71, $FF, 71, $FF,
 $FF, 72, 72, 72, $FF, 72, $FF, $FF, 72, 72, 72, 72, 72, $FF, 72, $FF,
 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, $FF, $FF, 72, 72, 72,
 $FF, $FF, 72, $FF, 72, 72, $FF, 72, $FF, $FF, $FF, $FF, $FF, $FF, 72, 72,
 72, $FF, $FF, $FF, 72, 72, $FF, $FF, $FF, 72, 72, $FF, $FF, $FF, $FF, $FF,
 $FF, $FF, 72, $FF, 72, 72, $FF, 72, 8, 8, $FF, $FF, 8, $FF, 72, 72,
 72, $FF, $FF, $FF, 72, 72, $FF, $FF, $FF, 72, 72, $FF, 72, $FF, $FF, 8,
 8, 8, $FF, 8, $FF, $FF, 8, 8, 8, 8, 8, $FF, 8, 8, 8, $FF,
 $FF, $FF, $FF, $FF, $FF, $FF, $FF, $FF, $FF, $FF, $FF, 8, 8, 8, $FF, $FF,
 8, $FF, 8, 8, $FF, 8, $FF, $FF, $FF, $FF, $FF, $FF, 8, 8, 8, $FF,
 $FF, $FF, 8, 8, $FF, $FF, $FF, 8, 8, $FF, $FF, $FF, $FF, $FF, $FF, $FF,
 8, $FF, 8, 8, $FF, 8, 74, 74, $FF, $FF, 74, $FF, 8, 8, 8, $FF,
 $FF, $FF, 8, 8, $FF, $FF, $FF, 8, 8, $FF, 8, $FF, $FF, 74, 74, 74,
 $FF, 74, $FF, $FF, 74, 74, 74, 74, 74, $FF, 74, $FF, 74, 74, 74, 74,
 74, 74, 74, 74, 74, 74, 74, $FF, $FF, 74, 74, 74, $FF, $FF, 74, $FF,
 74, 74, $FF, 74, $FF, $FF, $FF, $FF, $FF, $FF, 74, 74, 74, $FF, $FF, $FF,
 74, 74, $FF, $FF, $FF, 74, 74, $FF, $FF, $FF, $FF, $FF, $FF, $FF, 74, $FF,
 74, 74, $FF, 74, 75, 75, $FF, $FF, 75, $FF, 74, 74, 74, $FF, $FF, $FF,
 74, 74, $FF, $FF, $FF, 74, 74, $FF, 74, $FF, $FF, 75, 75, 75, $FF, 75,
 $FF, $FF, 75, 75, 75, 75, 75, $FF, 75, $FF, 75, 75, 75, 75, 75, 75,
 75, 75, 75, 75, 75, $FF, $FF, 75, 75, 75, $FF, $FF, 75, $FF, 75, 75,
 $FF, 75, $FF, $FF, $FF, $FF, $FF, $FF, 75, 75, 75, $FF, $FF, $FF, 75, 75,
 $FF, $FF, $FF, 75, 75, $FF, $FF, $FF, $FF, $FF, $FF, $FF, 75, $FF, 75, 75,
 $FF, 75, 3, 3, $FF, $FF, 3, $FF, 75, 75, 75, $FF, $FF, $FF, 75, 75,
 $FF, $FF, $FF, 75, 75, $FF, 75, $FF, $FF, 3, 3, 3, $FF, 3, $FF, $FF,
 3, 3, 3, 3, 3, $FF, 3, $FF, 3, 3, 3, 3, 3, 3, 3, 3,
 3, 3, 3, $FF, $FF, 3, 3, 3, $FF, $FF, 3, $FF, 3, 3, $FF, 3,
 $FF, $FF, $FF, $FF, $FF, $FF, 3, 3, 3, $FF, $FF, $FF, 3, 3, $FF, $FF,
 $FF, 3, 3, $FF, $FF, $FF, $FF, $FF, $FF, $FF, 3, $FF, 3, 3, $FF, 3,
 80, 80, $FF, $FF, 80, $FF, 3, 3, 3, $FF, $FF, $FF, 3, 3, $FF, $FF,
 $FF, 3, 3, $FF, 3, $FF, $FF, 80, 80, 80, $FF, 80, $FF, $FF, 80, 80,
 80, 80, 80, $FF, 80, $FF, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80,
 80, $FF, $FF, 80, 80, 80, $FF, $FF, 80, $FF, 80, 80, $FF, 80, $FF, $FF,
 $FF, $FF, $FF, $FF, 80, 80, 80, $FF, $FF, $FF, 80, 80, $FF, $FF, $FF, 80,
 80, $FF, $FF, $FF, $FF, $FF, $FF, $FF, 80, $FF, 80, 80, $FF, 80, 81, 81,
 $FF, $FF, 81, $FF, 80, 80, 80, $FF, $FF, $FF, 80, 80, $FF, $FF, $FF, 80,
 80, $FF, 80, $FF, $FF, 81, 81, 81, $FF, 81, $FF, $FF, 81, 81, 81, 81,
 81, $FF, 81, $FF, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, $FF,
 $FF, 81, 81, 81, $FF, $FF, 81, $FF, 81, 81, $FF, 81, $FF, $FF, $FF, $FF,
 $FF, $FF, 81, 81, 81, $FF, $FF, $FF, 81, 81, $FF, $FF, $FF, 81, 81, $FF,
 $FF, $FF, $FF, $FF, $FF, $FF, 81, $FF, 81, 81, $FF, 81, 82, 82, $FF, $FF,
 82, $FF, 81, 81, 81, $FF, $FF, $FF, 81, 81, $FF, $FF, $FF, 81, 81, $FF,
 81, $FF, $FF, 82, 82, 82, $FF, 82, $FF, $FF, 82, 82, 82, 82, 82, $FF,
 82, $FF, 82, 82, 82, 82, 82, 82, 82, 82, 82, 82, 82, $FF, $FF, 82,
 82, 82, $FF, $FF, 82, $FF, 82, 82, $FF, 82, $FF, $FF, $FF, $FF, $FF, $FF,
 82, 82, 82, $FF, $FF, $FF, 82, 82, $FF, $FF, $FF, 82, 82, $FF, $FF, $FF,
 $FF, $FF, $FF, $FF, 82, $FF, 82, 82, $FF, 82, 79, 79, $FF, $FF, 79, $FF,
 82, 82, 82, $FF, $FF, $FF, 82, 82, $FF, $FF, $FF, 82, 82, $FF, 82, $FF,
 $FF, 79, 79, 79, $FF, 79, $FF, $FF, 79, 79, 79, 79, 79, $FF, 79, $FF,
 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, $FF, $FF, 79, 79, 79,
 $FF, $FF, 79, $FF, 79, 79, $FF, 79, $FF, $FF, $FF, $FF, $FF, $FF, 79, 79,
 79, $FF, $FF, 79, 79, 79, $FF, $FF, $FF, 79, 79, $FF, $FF, $FF, $FF, $FF,
 $FF, $FF, 79, $FF, 79, 79, $FF, 79, 84, 84, $FF, $FF, 84, $FF, 79, 79,
 79, $FF, $FF, 79, 79, 79, $FF, $FF, $FF, 79, 79, $FF, 79, $FF, $FF, 84,
 84, 84, $FF, 84, $FF, $FF, 84, 84, 84, 84, 84, $FF, 84, $FF, 84, 84,
 84, 84, 84, 84, 84, 84, 84, 84, 84, $FF, $FF, 84, 84, 84, $FF, $FF,
 84, $FF, 84, 84, $FF, 84, $FF, $FF, $FF, $FF, $FF, $FF, 84, 84, 84, $FF,
 $FF, $FF, 84, 84, $FF, $FF, $FF, 84, 84, $FF, $FF, $FF, $FF, $FF, $FF, $FF,
 84, $FF, 84, 84, $FF, 84, 83, 83, $FF, $FF, 83, $FF, 84, 84, 84, $FF,
 $FF, $FF, 84, 84, $FF, $FF, $FF, 84, 84, $FF, 84, $FF, $FF, 83, 83, 83,
 $FF, 83, $FF, $FF, 83, 83, 83, 83, 83, $FF, 83, $FF, 83, 83, 83, 83,
 83, 83, 83, 83, 83, 83, 83, $FF, $FF, 83, 83, 83, $FF, $FF, 83, $FF,
 83, 83, $FF, 83, $FF, $FF, $FF, $FF, $FF, $FF, 83, 83, 83, $FF, $FF, $FF,
 83, 83, $FF, $FF, $FF, 83, 83, $FF, $FF, $FF, $FF, $FF, $FF, $FF, 83, $FF,
 83, 83, $FF, 83, $FF, $FF, $FF, $FF, $FF, $FF, 83, 83, 83, $FF, $FF, $FF,
 83, 83, $FF, $FF, $FF, 83, 83, $FF, 83, 0
);

type tableyy_default = array[0..86] of yy_state_t;
var yy_default: ^tableyy_default;
const tblyy_default: tableyy_default = (
 86, 86, 86, 0, 86, 86, 86, 86, 0, 86, 0, 0, 0, 86, 86, 86,
 86, 0, 0, 0, 0, 86, 86, 0, 0, 0, 0, 86, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 86, 86, 86, 86, 0, 0, 0, 0, 0, 9, 0, 0, 7, 86, 77, 0,
 0, 0, 0, 0, 0, 86, 0
);

type tableyy_base = array[0..86] of integer;
var yy_base: ^tableyy_base;
const tblyy_base: tableyy_base = (
 0, 5993, 2, 5305, 5993, 5993, 5993, 943, 5023, 81, 4741, 4553, 4271, 5993, 3, 30,
 2, 3227, 2475, 2099, 1629, 5993, 5993, 1159, 585, 209, 115, 5, 303, 397, 491, 679,
 1065, 773, 867, 971, 1441, 1253, 1347, 1535, 1723, 1817, 1911, 2005, 2193, 2287, 2381, 2569,
 2663, 2757, 2851, 2945, 3039, 3133, 3321, 3415, 3509, 3603, 3697, 3791, 3885, 3979, 4073, 4177,
 5993, 5993, 5993, 5993, 4365, 4459, 4647, 4835, 4929, 5993, 5117, 5211, 12, 4149, 5993, 5681,
 5399, 5493, 5587, 5869, 5775, 5993, 5993
);


{LINE 21 c:/etc/yylex.pas}


(*
 * the following can be redefined by the user.
 *)
{$IFNDEF YYLMAX_DEFINED}
{$DEFINE YYLMAX_DEFINED}
const
  YYLMAX = 100;		(* token and pushback buffer size *)
  YYLMAX1 = 101;    	(**** always 1 more then YYLMAX ****)
{$ENDIF}

(*
 * yy_sbuf[0:yyleng-1] contains the states corresponding to yytext.
 * yytext[0:yyleng-1] contains the current token.
 * yytext[yyleng:yy_end-1] contains pushed-back characters.
 * When the user action routine is active,
 * yy_save contains yytext[yyleng], which is set to '\0'.
 * Things are different when YY_PRESERVE is defined.
 * YYFILE_EXTERNAL allows the definition of yyin and yyout in
 * other modules of your Pascal project based on lex output
 *)
var
   cs_globs :  TRTLCriticalSection;

threadvar
{$IFNDEF YYTEXT_BUF_EXTERNAL}
	yytext: array[0..YYLMAX1] of char; (* text buffer (really yytext) *)
{$ENDIF}
	yy_sbuf: array[0..YYLMAX1] of yy_state_t;	(* state buffer *)
{$IFNDEF YYIOSTREAMED}
{$IFNDEF YYFILE_EXTERNAL}
	yyin,
	yyout,
        yyerr: text;
{$ENDIF}
{$ENDIF}
	yyLexFatal: integer;

const
  YY_INTERACTIVE = 1;  (* bit faster if 0 *)
  yybits: array[0..7] of Byte = (1, 2, 4, 8, 16, 32, 64, 128);

threadvar
  yylineno,
  yyleng,
  yy_end,
  yy_start,
  yy_lastc: Integer;
  yy_save: char;		(* saved yytext[yyleng] *)

(* Need a definition for yywrap to compile
 * Either issue 'use wrap' after compiling /lib/yywrap.pas,
 * or uncomment the following simple definition:
 *)
{$IFNDEF YYWRAP_EXTERNAL}
function yywrap: integer;
begin
  yywrap := 1;
end;
{$ENDIF}

(* built-in functions for yylex *)

function input: integer; forward;
procedure unput(c: integer); forward;

procedure ECHO (msg: string);
begin
{$IFNDEF YYIOSTREAMED}
  write(yyout, msg);
{$ELSE}
  yyout.WriteBuffer(msg[1], Length(msg));
{$ENDIF}
end;

(*
 * yygetc: return next character from input
 * Turbo Pascal seems to have a bug in release 4.0
 * wherein Eof(yyin) fails after ^Z is typed on a terminal read
 * Suppress runtime library checking and do our own.
 *)
function yygetc : integer;
var
  ch: char;
begin
{$IFNDEF YYIOSTREAMED}
  if not EOF(yyin) then begin
    Read(yyin, ch);
    if IOResult <> 0 then
      result := -1
    else
      result := ord(ch)
  end else
    result := -1
{$ELSE}
  (* Read the input from TStream object *)
  if yyin.Position < yyin.Size then begin
    yyin.ReadBuffer(ch, 1);
    result := Ord(ch);
  end else
    result := -1;
{$ENDIF}
end;

procedure output(c: char);
begin
{$IFNDEF YYIOSTREAMED}
  write(yyout, c);
{$ELSE}
  yyout.WriteBuffer(c, 1);
{$ENDIF}
end;

procedure YY_FATAL (msg: string);
begin
{$IFNDEF YYIOSTREAMED}
  writeln(yyerr, 'yylex: ',msg);
{$ELSE}
  msg := msg + #13 + #10;
  yyout.WriteBuffer(msg[1], Length(msg));
{$ENDIF}
  yyLexFatal := 1;
end;

procedure YY_INIT;
begin
  yy_start := 0;
  yyleng := 0;
  yy_end := 0;
  yy_lastc := YYNEWLINE
end;

procedure yy_reset;
begin
  YY_INIT;
  yylineno := 1;
end;

procedure YYBEGIN (state: integer);
begin
  yy_start := state
end;

procedure NLSTATE;
begin
  yy_lastc := YYNEWLINE
end;

(*
 * the following must not be redefined.
 *)
procedure YY_SCANNER; forward;
procedure YY_USER; forward;

procedure YY_USER;	(* set up yytext for user *)
begin
  yy_save := yytext[yyleng];
  yytext[yyleng] := Char(0)
end;

procedure YY_SCANNER;	(* set up yytext for scanner *)
begin
  yytext[yyleng] := yy_save
end;

procedure yyless (n: integer);
begin
  if (n >= 0) and (n <= yy_end) then begin
    YY_SCANNER;
    yyleng := n;
    YY_USER
  end
end;

(* The following (yycomment) can be changed *)

(*
 * yycomment(trailing-comment-string)
 *	skip comment input, accounting for newlines
 *)
procedure yycomment (mat: string);
var
  c:	integer;
  icp:	integer;
  done:	boolean;
begin
  icp := 1;
  done := false;
  while (icp <= length(mat)) and (not done) do begin
    c := input;
    if c = -1 then begin
      YY_FATAL('end of file in comment');
      done := true
    end else if c <> ord(mat[icp]) then begin
      if c = ord(mat[1]) then
        icp := 2
      else
        icp := 1;
    end else
      inc(icp)
  end;
end;


(*
 * The actual lexical scanner
 *)
function yylex : integer;
{LINE 59 ExprLexer.l}

var
  v: Variant;
{LINE 230 c:/etc/yylex.pas}

var
	retval, c, i, yyst, yybase: integer;
	yyfmin, yyfmax: integer;	(* yy_la_act index of final states *)
	yyoldi, yyoleng: integer;	(* base i, yyleng before look-ahead *)
	yyeof: integer;			(* 1 if eof has already been read *)
label
	yy_again,
	yy_contin,
	yy_jammed,
	yy_search,
	yy_found,
	done_loop,
	loop_exit,
	yy_reject,
	yy_more,
	yylexReturn;

begin
  yyLexFatal := 0;
  yyeof := 0;
  i := yyleng;
  YY_SCANNER;

  yy_again:
    yyleng := i;
    (* determine previous char. *)
    if i > 0 then
      yy_lastc := Integer(yytext[i-1]);
    (* scan previously accepted token adjusting yylineno *)
    while (i > 0) do begin
      dec(i);
      if Integer(yytext[i]) = YYNEWLINE then
        inc(yylineno)
    end;
    (* adjust pushback *)
    dec(yy_end, yyleng);
    for i := 0 to yy_end - 1 do
      yytext[i] := yytext[yyleng + i];
    i := 0;
  yy_contin:
    yyoldi := i;

    (* run the state machine until it jams *)
    if yy_lastc = YYNEWLINE then
      yyst := tblyy_begin[yy_start + 1]
    else
      yyst := tblyy_begin[yy_start];
    yy_sbuf[i] := yyst;

    repeat
      if i >= YYLMAX then begin
        YY_FATAL('Token buffer overflow');
	if yyLexFatal = 1 then begin
	  retval := -2;
	  goto yylexReturn;
        end;
      end;
      (* get input char *)
      if i < yy_end then
        c := Integer(yytext[i])    (* get pushback char *)
      else begin
      	if yyeof = 0 then
	  c := yygetc
        else
	  c := -1;
        if c <> -1 then begin
          yy_end := i+1;
	  yytext[i] := chr(c)
        end else begin	(* end of file *)
          if i = yyoldi then begin
            yyeof := 0;
	    if yywrap <> 0 then begin
              retval := 0;
              goto yylexReturn
            end else
              goto yy_again
          end else begin
            yyeof := 1;	(* don't re-read EOF *)
            goto loop_exit
          end
        end
      end;
      (* look up next state *)
      yybase := tblyy_base[yyst] + c;
      while (yybase > yy_nxtmax) or (tblyy_check[yybase] <> yyst) do begin
        if yyst = yy_endst then
          goto yy_jammed;
        yyst := tblyy_default[yyst];
        yybase := tblyy_base[yyst] + c
      end;
      yyst := tblyy_next[yybase];

    yy_jammed:
      inc(i);
      yy_sbuf[i] := yyst
    until (yyst = yy_endst) or (YY_INTERACTIVE <> 0) and
          (tblyy_base[yyst] > yy_nxtmax) and
          (tblyy_default[yyst] = yy_endst) ;

  loop_exit:
    if yyst <> yy_endst then
      inc(i);

  yy_search:
    (* search backward for a final state *)
    dec(i);
    while i > yyoldi do begin
      yyst := yy_sbuf[i];
      yyfmin := tblyy_final[yyst];
      yyfmax := tblyy_final[yyst+1];
      if yyfmin < yyfmax then
        goto yy_found;	(* found final state(s) *)
      dec(i);
    end;
    (* no match, default action *)
    i := yyoldi + 1;
    output(char(yytext[yyoldi]));
    goto yy_again;

  yy_found:
    yyoleng := i;		(* save length for REJECT *)
    (* pushback look-ahead RHS *)
    c := (integer(tblyy_la_act[yyfmin]) shr 9) - 1;

    if c >= 0 then begin		(* trailing context? *)
      while true do begin
        dec(i);
        if i < yyoldi then begin
          i := yyoleng;
          goto done_loop
        end else begin
          yyst := yy_sbuf[i];
          if ((tblyy_look[c*YY_LA_SIZE+word(yyst) div 8] and
               yybits[word(yyst) mod 8]) <> 0) then
            goto done_loop;
        end
      end;
    done_loop:
    end;

    (* perform action *)
    yyleng := i;
    YY_USER;
    case (tblyy_la_act[yyfmin] and $1FF) of
0:
begin
{LINE 63 ExprLexer.l}
	
  retval := Integer(yytext[0]);
  goto yylexReturn;


end;
1:
begin
{LINE 67 ExprLexer.l}
	yycomment('*/')

end;
2:
begin
{LINE 68 ExprLexer.l}
	
  retval := _NOT;
  goto yylexReturn;


end;
3:
begin
{LINE 72 ExprLexer.l}
	
  retval := _STRING;
  GetString(Integer('"'));
  StrCopy(yylval.svalue, yytext);
  goto yylexReturn;


end;
4:
begin
{LINE 78 ExprLexer.l}
	
  retval := _STRING;
  GetString(Integer(''''));
  StrCopy(yylval.svalue, yytext);
  goto yylexReturn;


end;
5:
begin
{LINE 84 ExprLexer.l}
	
  retval := _DATE;
  GetString(Integer('}'));
  yylval.dvalue := StrToDate(String(yytext));
  goto yylexReturn;


end;
6:
begin
{LINE 90 ExprLexer.l}
	
  retval := _NUM;
  yylval.nvalue.NumType := EXPR_NUMTYPE_DOUBLE;
  yylval.nvalue.dvalue := StrToFloat(String(yytext));
  goto yylexReturn;


end;
7:
begin
{LINE 96 ExprLexer.l}
	
  retval := _NUM;
  yylval.nvalue.NumType := EXPR_NUMTYPE_INTEGER;
  yylval.nvalue.ivalue := StrToInt(String(yytext));
  goto yylexReturn;


end;
8:
begin
{LINE 102 ExprLexer.l}
	
  retval := _NUM;
  yylval.nvalue.NumType := EXPR_NUMTYPE_INTEGER;
  yylval.nvalue.ivalue := StrToInt(String(yytext));
  goto yylexReturn;


end;
9:
begin
{LINE 108 ExprLexer.l}
	
  retval := _AND;
  goto yylexReturn;


end;
10:
begin
{LINE 112 ExprLexer.l}
	
  retval := _NAND;
  goto yylexReturn;


end;
11:
begin
{LINE 116 ExprLexer.l}
	
  retval := _OR;
  goto yylexReturn;


end;
12:
begin
{LINE 120 ExprLexer.l}
	
  retval := _XOR;
  goto yylexReturn;


end;
13:
begin
{LINE 124 ExprLexer.l}
	
  retval := _NOR;
  goto yylexReturn;


end;
14:
begin
{LINE 128 ExprLexer.l}
	
  retval := _EQ;
  goto yylexReturn;


end;
15:
begin
{LINE 132 ExprLexer.l}
	
  retval := _NEQ;
  goto yylexReturn;


end;
16:
begin
{LINE 136 ExprLexer.l}
	
  retval := _NEQ;
  goto yylexReturn;


end;
17:
begin
{LINE 140 ExprLexer.l}
	
  retval := _LEQ;
  goto yylexReturn;


end;
18:
begin
{LINE 144 ExprLexer.l}
	
  retval := _GEQ;
  goto yylexReturn;


end;
19:
begin
{LINE 148 ExprLexer.l}
	
  retval := _GT;
  goto yylexReturn;


end;
20:
begin
{LINE 152 ExprLexer.l}
	
  retval := _LT;
  goto yylexReturn;


end;
21:
begin
{LINE 156 ExprLexer.l}
	
  retval := _STARTS_WITH;
  goto yylexReturn;


end;
22:
begin
{LINE 160 ExprLexer.l}
	
  retval := _CONTAINS;
  goto yylexReturn;


end;
23:
begin
{LINE 164 ExprLexer.l}
	
  retval := _TRUE;
  goto yylexReturn;


end;
24:
begin
{LINE 168 ExprLexer.l}
	
  retval := _FALSE;
  goto yylexReturn;


end;
25:
begin
{LINE 172 ExprLexer.l}
	
  retval := _PLUS;
  goto yylexReturn;


end;
26:
begin
{LINE 176 ExprLexer.l}
	
  retval := _MINUS;
  goto yylexReturn;


end;
27:
begin
{LINE 180 ExprLexer.l}
	
  retval := _TIMES;
  goto yylexReturn;


end;
28:
begin
{LINE 184 ExprLexer.l}
	
  retval := _DIV;
  goto yylexReturn;


end;
29:
begin
{LINE 188 ExprLexer.l}
	
  retval := _DIVIDE;
  goto yylexReturn;


end;
30:
begin
{LINE 192 ExprLexer.l}
	
  retval := _MOD;
  goto yylexReturn;


end;
31:
begin
{LINE 196 ExprLexer.l}
	
  retval := _DATESPEC;
  yylval.nvalue.ivalue := MSPEC_MONTH;
  goto yylexReturn;


end;
32:
begin
{LINE 201 ExprLexer.l}
	
  retval := _DATESPEC;
  yylval.nvalue.ivalue := MSPEC_DAY;
  goto yylexReturn;


end;
33:
begin
{LINE 206 ExprLexer.l}
	
  retval := _DATESPEC;
  yylval.nvalue.ivalue := MSPEC_YEAR;
  goto yylexReturn;


end;
34:
begin
{LINE 211 ExprLexer.l}
	
  v := SymTab.Value[UpperCase(String(yytext))];
  case VarType(v) of
    varDate: begin
      retval := _DATE;
      yylval.dvalue := v;
    end;
    varInteger, varDouble: begin
      retval := _NUM;
      if VarType(v) = varInteger then begin
        yylval.nvalue.NumType := EXPR_NUMTYPE_INTEGER;
        yylval.nvalue.ivalue := v;
      end else begin
        yylval.nvalue.NumType := EXPR_NUMTYPE_DOUBLE;
        yylval.nvalue.dvalue := v;
      end;
    end;
    varString: begin
      retval := _STRING;
      StrPCopy(yylval.svalue, v);
    end;
    else begin
      retval := _STRING;
      StrPCopy(yylval.svalue, '');
    end;
  end;
  goto yylexReturn;


end;
35:
begin
{LINE 239 ExprLexer.l}
	
  (* Skip over white space *)


end;

{LINE 375 c:/etc/yylex.pas}

    end;
    YY_SCANNER;
    i := yyleng;
    goto yy_again;			(* action fell though *)

  yy_reject:
    YY_SCANNER;
    i := yyoleng;			(* restore original yytext *)
    inc(yyfmin);
    if yyfmin < yyfmax then
      goto yy_found		(* another final state, same length *)
    else
      goto yy_search;		(* try shorter yytext *)

  yy_more:
    YY_SCANNER;
    i := yyleng;
    if i > 0 then
      yy_lastc := Integer(yytext[i-1]);
    goto yy_contin;

yylexReturn:
    result := retval
end;		{ end of yylex }

(*
 * user callable input/unput functions.
 *)
(* get input char with pushback *)
function input: integer;
var
  c: integer;
begin
  if yy_end > yyleng then begin
    dec(yy_end);
    for c := 0 to yy_end-yyleng-1 do
      yytext[yyleng+c] := yytext[yyleng+1+c];
    c := ord(yy_save);
    YY_USER;
  end else
    c := yygetc;
  yy_lastc := c;
  if c = YYNEWLINE then
    inc(yylineno);
  result := c;
end;

(* pushback char *)
procedure unput(c: integer);
var
  i: word;
begin
  if yy_end >= YYLMAX then
    YY_FATAL('Push-back buffer overflow')
  else begin
    if yy_end > yyleng then begin
      yytext[yyleng] := yy_save;
      for i := 0 to yy_end - yyleng - 1 do
        yytext[yyleng+i+1] := yytext[yyleng];
      yytext[yyleng] := Char(0);
    end;
    inc(yy_end);
    yy_save := chr(c);

    if c = YYNEWLINE then
      dec(yylineno);
  end;
end;

procedure yylex_initialization;
begin
  InitializeCriticalSection(cs_globs);
  yy_reset;
end;

procedure yylex_finalization;
begin
  DeleteCriticalSection(cs_globs);
end;

{LINE 243 ExprLexer.l}

procedure GetString(str_delim: Integer);
var
  ch, i: Integer;
begin
  ch := input;
  i := 0;
  while ((ch >= 0) and (i < yylmax1)) do begin
    if (ch = str_delim) then begin
      ch := input;
      if (ch <> str_delim) then begin
        unput(ch);
	break;
      end;
    end;
    yytext[i] := Char(ch);
    Inc(i);
    ch := input;
  end;
  if (ch < 0) then
    yyerror('EOF detected in symbol value');
  if (i = yylmax1) then
    yyerror('String too long');
  yytext[i] := #0;
end;

initialization

  InitializeCriticalSection(cs_globs);

finalization

  DeleteCriticalSection(cs_globs);

end.
