unit WeekOfYear;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ibase, FreeUDFLib;

type
  TfWeekOfYear = class(TForm)
    txtDate: TEdit;
    btnTest: TButton;
    Label1: TLabel;
    lblDelphi: TLabel;
    lblWeek: TLabel;
    lblYear: TLabel;
    Label2: TLabel;
    procedure btnTestClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  fWeekOfYear: TfWeekOfYear;

implementation

uses
  Main;

{$R *.DFM}

procedure TfWeekOfYear.btnTestClick(Sender: TObject);
var
  d: TDateTime;
  ibd: TISC_QUAD;
  yr, wk: Integer;
  dy, dm, dd: Word;
begin
  try
    d := StrToDate(txtDate.Text);
    ibd := DateToQuad(d);
    yr := YearOfYear(@ibd);
    wk := FreeUDFLib.WeekOfYear(@ibd);
    DecodeDate(d, dy, dm, dd);
    lblDelphi.Caption :=
      LongDayNames[SysUtils.DayOfWeek(d)] + ', ' +
      LongMonthNames[dm] + ' ' +
      IntToStr(dd) + ', ' +
      IntToStr(dy);
    lblYear.Caption := 'Year: ' + IntToStr(yr);
    lblWeek.Caption := 'Week: ' + IntToStr(wk);
  finally
    txtDate.SelectAll;
  end;
end;

end.
