unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Buttons, StdCtrls, Db, IBDatabase, Grids, DBGrids, IBCustomDataSet,
  IBQuery, IBSQL, CheckLst;

type
  TForm1 = class(TForm)
    DB: TIBDatabase;
    Label1: TLabel;
    Edit1: TEdit;
    btnBrowse: TSpeedButton;
    btnCheck: TSpeedButton;
    OpenDialog1: TOpenDialog;
    qFields: TIBQuery;
    lCount: TLabel;
    Label3: TLabel;
    lTableName: TLabel;
    qTables: TIBQuery;
    lbTables: TCheckListBox;
    btnStart: TSpeedButton;
    Label2: TLabel;
    btnStop: TSpeedButton;
    Log: TMemo;
    Label4: TLabel;
    Q: TIBSQL;
    TR: TIBTransaction;
    procedure btnBrowseClick(Sender: TObject);
    procedure btnCheckClick(Sender: TObject);
    procedure btnStartClick(Sender: TObject);
    procedure btnStopClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.btnBrowseClick(Sender: TObject);
begin
 if OpenDialog1.Execute then
   Edit1.Text:=OpenDialog1.FileName;
end;

const fs: string = 'Found %d fields in %d tables with NOT NULL definition.';
procedure TForm1.btnCheckClick(Sender: TObject);
begin
 if DB.Connected then
  DB.Connected:=False;
 DB.DatabaseName:=Edit1.Text;
 DB.Connected:=True;
 TR.StartTransaction;
 qFields.Open; qFields.Last;
 qTables.Open; qTables.Last;
 lCount.Caption:=Format(fs, [qFields.RecordCount, qTables.RecordCount]);
 lCount.Visible:=True;
 qTables.First;
 lbTables.Items.Clear;
 while not qTables.EOF do
   begin
     lbTables.Items.Add(qTables.FieldByName('RDB$RELATION_NAME').asString);
     lbTables.Checked[lbTables.Items.Count-1]:=True;
     qTables.Next;
   end;
end;

var
  Running: boolean;

procedure TForm1.btnStartClick(Sender: TObject);
var
 i: integer;
 s: string;
begin
  Log.Clear;
  Running:=True;
  for i:=0 to lbTables.Items.Count-1 do
    begin
      if lbTables.Checked[i] then // process only selected tables
        begin
          s:=lbTables.Items[i];
          lTableName.Caption:=s;
          Application.ProcessMessages;
          // break if stop button pressed
          if not Running then Exit;
          Q.SQL.Clear;
          Q.SQL.Add('SELECT * FROM '+TrimRight(s));
          Q.ExecQuery;
          Q.Next;
          if Q.RecordCount >= 1 then // it is not an empty table.
            begin
              qFields.First;
              qFields.Locate('RDB$RELATION_NAME', s, []);
              // run query for each found not null field in a table
              while (qFields.FieldByName('RDB$RELATION_NAME').asString = s) and not (qFields.EOF) do
                begin
                  Q.Close;
                  Q.SQL.Clear;
                  Q.SQL.Add('SELECT COUNT(*) FROM '+TrimRight(s));
                  Q.SQL.Add('WHERE '+qFields.FieldByName('RDB$FIELD_NAME').asString+' IS NULL');
                  Q.ExecQuery;
                  Q.Next;
                  if Q.Current[0].asinteger > 0 then // write message to error log
                    Log.Lines.Add('Warning: Field '+TrimRight(qFields.FieldByName('RDB$FIELD_NAME').asString)+
                                  ' in Table '+TrimRight(qFields.FieldByName('RDB$RELATION_NAME').asString)+
                                  ' have null values!');
                  qFields.Next;
                end;
            end;
          Q.Close;
        end;
    end;
  if not (DB.Connected) then
    ShowMessage('You are not connected to database.')
  else
    ShowMessage('Checking process complete.'#10#13'See Log for details');
end;

procedure TForm1.btnStopClick(Sender: TObject);
begin
  Running:=False;
end;

end.
