{*******************************************************************}
{                                                                   }
{    Copyright () 1998-2000 RCAV rcav@peterlink.ru                 }
{                                                                   }
{    :   (LOA)  loa@mail.ru                          }
{                                                                   }
{*******************************************************************}

program gdrop;
{$APPTYPE CONSOLE}


uses
  Windows, SysUtils, Classes, DB, IBDataBase, IBSQL;

function MakeDelimetter(Level: Integer): AnsiString;
var
  Len : Integer;
begin
  Result := '';
  if Level > 1 then
  begin
    Len := (Level - 2) * 3 + 3;
    SetLength(Result, Len);
    FillChar(Result[1], Len, ' ');
  end;
end;

function MakePetName(DependedType: Integer): String;
begin
  case DependedType of
    1: // view
      Result := '(v)';
    2: // trigger
      Result := '(t)';
    4: // check
      Result := '(c)';
    5: // procedure
      Result := '(p)';
    7: // exception
      Result := '(x)';
    10: // index
      Result := '(i)';
    11: // udf
      Result := '(f)';
    else
      Result := '(ERROR)';
  end;
end;

type
  TProcessingFlag = (pfSilent, pfCommitRetaining);
  TProcessingFlags = set of TProcessingFlag;

var
  ADatabaseName, AUserName, APassword: string;
  ASQL: TIBSQL;
  DropSequence: TStrings;
  ProcessingFlags : TProcessingFlags;
  I: Integer;

procedure AddDrop(DependedName: string; DependedType: Integer; Level: Integer);
var
  LocalSQL: TIBSQL;
  ConstraintType: String;
  RelationName: String;
  ConstraintIndexName: String;
  Stream: TStringStream;
  IsDepending :Boolean;
begin
  DependedName := AnsiUpperCase(Trim(DependedName));

  if DropSequence.IndexOf(Format('%s=%d', [DependedName, DependedType])) <> -1 then
    Exit;

  if not (pfSilent in ProcessingFlags) then
    WriteLn(MakeDelimetter(Level), DependedName + ' ' + MakePetName(DependedType));

  LocalSQL := TIBSQL.Create(Nil);
  try
    LocalSQL.Database    := ASQL.DataBase;
    LocalSQL.Transaction := ASQL.Transaction;

    try
      if DependedType <> 4 then
      begin
        LocalSQL.SQL.Text :=
          Format('select ' +
                 '  d.rdb$dependent_name, d.rdb$dependent_type ' +
                 'from ' +
                 '  rdb$dependencies d ' +
                 'where ' +
                 '  d.rdb$depended_on_name = "%s" and ' +
                 '  d.rdb$dependent_name <> "%0:s" and ' +
                 '  d.rdb$field_name is null', [DependedName]);

        LocalSQL.ExecQuery;
        while not LocalSQL.EOF do
        begin
          AddDrop(LocalSQL.Fields[0].AsString, LocalSQL.Fields[1].AsInteger, Level + 1);
          LocalSQL.Next;
        end;
        LocalSQL.Close;
      end;

      case DependedType of
        1: // view
        begin
          if DependedName <> '*' then
            LocalSQL.SQL.Text := Format('drop view %s', [DependedName])
          else
          begin
            LocalSQL.SQL.Text := 'select distinct v.rdb$view_name from rdb$view_relations v';

            LocalSQL.ExecQuery;
            while not LocalSQL.EOF do
            begin
              AddDrop(LocalSQL.Fields[0].AsString, 1, Level + 1);
              LocalSQL.Next;
            end;
            LocalSQL.Close;

            Exit;
          end;
        end;
        2: // trigger
        begin
          if DependedName <> '*' then
            LocalSQL.SQL.Text := Format('drop trigger %s', [DependedName])
          else
          begin
            LocalSQL.SQL.Text :=
              'select t.rdb$trigger_name ' +
              'from ' +
              '  rdb$triggers t ' +
              'where ' +
              ' (t.rdb$system_flag is null or t.rdb$system_flag = 0) and ' +
              '  not exists(select * ' +
              '             from ' +
              '               rdb$check_constraints cc ' +
              '             where ' +
              '               cc.rdb$trigger_name = t.rdb$trigger_name)';

            LocalSQL.ExecQuery;
            while not LocalSQL.EOF do
            begin
              AddDrop(LocalSQL.Fields[0].AsString, 2, Level + 1);
              LocalSQL.Next;
            end;

            LocalSQL.Close;

            Exit;
          end;
        end;
        4: // check
        begin
          if DependedName <> '*' then
          begin
            LocalSQL.SQL.Text :=
              Format('select ' +
                     '  c.rdb$constraint_type, c.rdb$relation_name, c.rdb$index_name ' +
                     'from ' +
                     '  rdb$relation_constraints c ' +
                     'where ' +
                     '  c.rdb$constraint_name = "%s"', [DependedName]);

            LocalSQL.ExecQuery;
            ConstraintType         := Trim(LocalSQL.Fields[0].AsString);
            RelationName           := Trim(LocalSQL.Fields[1].AsString);
            ConstraintIndexName    := Trim(LocalSQL.Fields[2].AsString);
            LocalSQL.Close;

            if (ConstraintType = 'PRIMARY KEY') or
               (ConstraintType = 'UNIQUE') then
            begin
              //     Foreign key's
              LocalSQL.SQL.Text :=
                Format('select ' +
                       '  rc.rdb$constraint_name ' +
                       'from ' +
                       '  rdb$ref_constraints rc ' +
                       'where ' +
                       '  rc.rdb$const_name_uq = "%s"', [DependedName]);

              LocalSQL.ExecQuery;
              while not LocalSQL.EOF do
              begin
                AddDrop(LocalSQL.Fields[0].AsString, 4, Level + 1);
                LocalSQL.Next;
              end;
              LocalSQL.Close;
            end;

            if ConstraintType <> 'CHECK' then
            begin
              //    
              // walking dependent procedures
              LocalSQL.SQL.Text :=
                Format('select ' +
                       '  d.rdb$dependent_name, d.rdb$dependent_type, p.rdb$procedure_source ' +
                       'from ' +
                       '  rdb$dependencies d ' +
                       '  join rdb$procedures p on d.rdb$dependent_name = p.rdb$procedure_name ' +
                       'where ' +
                       '  d.rdb$depended_on_name = "%s" and ' +
                       '  d.rdb$dependent_type = 5 and ' +
                       '  d.rdb$field_name is null', [RelationName]);

              LocalSQL.ExecQuery;
              while not LocalSQL.EOF do
              begin
                Stream := TStringStream.Create('');
                with Stream do
                try
                  LocalSQL.Fields[2].SaveToStream(Stream);
                  IsDepending := (Stream.Size > 0) and (Pos(ConstraintIndexName, AnsiUpperCase(Stream.DataString)) > 0);
                finally
                  FreeAndNil(Stream);
                end;

                if IsDepending then
                   AddDrop(LocalSQL.Fields[0].AsString, LocalSQL.Fields[1].AsInteger, Level + 1);

                LocalSQL.Next;
              end;
              LocalSQL.Close;

              //    
              // walking dependent triggers
              LocalSQL.SQL.Text :=
                Format('select ' +
                       '  d.rdb$dependent_name, d.rdb$dependent_type, t.rdb$trigger_source ' +
                       'from ' +
                       '  rdb$dependencies d ' +
                       '  join rdb$triggers t on d.rdb$dependent_name = t.rdb$trigger_name ' +
                       'where ' +
                       '  d.rdb$depended_on_name = "%s" and ' +
                       '  d.rdb$dependent_type = 2 and ' +
                       '  d.rdb$field_name is null and ' +
                       '  not exists(select * ' +
                       '             from ' +
                       '               rdb$check_constraints cc ' +
                       '             where ' +
                       '               cc.rdb$trigger_name = t.rdb$trigger_name)', [RelationName]);

              LocalSQL.ExecQuery;
              while not LocalSQL.EOF do
              begin
                Stream := TStringStream.Create('');
                with Stream do
                try
                  LocalSQL.Fields[2].SaveToStream(Stream);
                  IsDepending := (Stream.Size > 0) and (Pos(ConstraintIndexName, AnsiUpperCase(Stream.DataString)) > 0);
                finally
                  FreeAndNil(Stream);
                end;

                if IsDepending then
                   AddDrop(LocalSQL.Fields[0].AsString, LocalSQL.Fields[1].AsInteger, Level + 1);

                LocalSQL.Next;
              end;
              LocalSQL.Close;

              //    
              // walking dependent checks
              LocalSQL.SQL.Text :=
                Format('select ' +
                       '  cc.rdb$constraint_name, cast(4 as smallint), t.rdb$trigger_source ' +
                       'from ' +
                       '  rdb$dependencies d ' +
                       '  join rdb$triggers t on d.rdb$dependent_name = t.rdb$trigger_name ' +
                       '  join rdb$check_constraints cc on t.rdb$trigger_name = cc.rdb$trigger_name ' +
                       'where ' +
                       '  d.rdb$depended_on_name = "%s" and ' +
                       '  d.rdb$dependent_type = 2 and ' +
                       '  d.rdb$field_name is null', [RelationName]);

              LocalSQL.ExecQuery;
              while not LocalSQL.EOF do
              begin
                Stream := TStringStream.Create('');
                with Stream do
                try
                  LocalSQL.Fields[2].SaveToStream(Stream);
                  IsDepending := (Stream.Size > 0) and (Pos(ConstraintIndexName, AnsiUpperCase(Stream.DataString)) > 0);
                finally
                  FreeAndNil(Stream);
                end;

                if IsDepending then
                   AddDrop(LocalSQL.Fields[0].AsString, LocalSQL.Fields[1].AsInteger, Level + 1);

                LocalSQL.Next;
              end;
              LocalSQL.Close;
            end;

            LocalSQL.SQL.Text := Format('alter table %s drop constraint %s', [RelationName, DependedName]);
          end
          else
          begin
            LocalSQL.SQL.Text :=
              'select ' +
              '  c.rdb$constraint_name ' +
              'from ' +
              '  rdb$relation_constraints c ' +
              'where ' +
              '  c.rdb$constraint_type in ("CHECK", "FOREIGN KEY", "UNIQUE", "PRIMARY KEY")';

            LocalSQL.ExecQuery;
            while not LocalSQL.EOF do
            begin
              AddDrop(LocalSQL.Fields[0].AsString, 4, Level + 1);
              LocalSQL.Next;
            end;
            LocalSQL.Close;

            Exit;
          end;
        end;
        5: // procedure
        begin
          if DependedName <> '*' then
            LocalSQL.SQL.Text := Format('drop procedure %s', [DependedName])
          else
          begin
            LocalSQL.SQL.Text :=
              'select ' +
              '  p.rdb$procedure_name ' +
              'from ' +
              '  rdb$procedures p ' +
              'where ' +
              '  p.rdb$system_flag is null or p.rdb$system_flag = 0';

            LocalSQL.ExecQuery;
            while not LocalSQL.EOF do
            begin
              AddDrop(LocalSQL.Fields[0].AsString, 5, Level + 1);
              LocalSQL.Next;
            end;
            LocalSQL.Close;

            Exit;
          end;
        end;
        7: // exception
        begin
          if DependedName <> '*' then
            LocalSQL.SQL.Text := Format('drop exception %s', [DependedName])
          else
          begin
            LocalSQL.SQL.Text :=
              'select ' +
              '  e.rdb$exception_name ' +
              'from ' +
              '  rdb$exceptions e ' +
              'where ' +
              '  e.rdb$system_flag is null or e.rdb$system_flag = 0';

            LocalSQL.ExecQuery;
            while not LocalSQL.EOF do
            begin
              AddDrop(LocalSQL.Fields[0].AsString, 7, Level + 1);
              LocalSQL.Next;
            end;
            LocalSQL.Close;

            Exit;
          end;
        end;
        10: // index
        begin
          if DependedName <> '*' then
          begin
            LocalSQL.SQL.Text :=
              Format('select ' +
                     '  i.rdb$relation_name ' +
                     'from ' +
                     '  rdb$indices i ' +
                     'where ' +
                     '  i.rdb$index_name = "%s"', [DependedName]);

            LocalSQL.ExecQuery;
            RelationName := Trim(LocalSQL.Fields[0].AsString);
            LocalSQL.Close;

            //     Foreign key's
            // walking dependent foreign keys
            LocalSQL.SQL.Text :=
              Format('select ' +
                     '  rc.rdb$constraint_name ' +
                     'from ' +
                     '  rdb$ref_constraints rc ' +
                     'where ' +
                     '  rc.rdb$const_name_uq = "%s"', [DependedName]);

            LocalSQL.ExecQuery;
            while not LocalSQL.EOF do
            begin
              AddDrop(LocalSQL.Fields[0].AsString, 4, Level + 1);
              LocalSQL.Next;
            end;
            LocalSQL.Close;

            //    
            // walking dependent procedures
            LocalSQL.SQL.Text :=
              Format('select ' +
                     '  d.rdb$dependent_name, d.rdb$dependent_type, p.rdb$procedure_source ' +
                     'from ' +
                     '  rdb$dependencies d ' +
                     '  join rdb$procedures p on d.rdb$dependent_name = p.rdb$procedure_name ' +
                     'where ' +
                     '  d.rdb$depended_on_name = "%s" and ' +
                     '  d.rdb$dependent_type = 5 and ' +
                     '  d.rdb$field_name is null', [RelationName]);

            LocalSQL.ExecQuery;
            while not LocalSQL.EOF do
            begin
              Stream := TStringStream.Create('');
              with Stream do
              try
                LocalSQL.Fields[2].SaveToStream(Stream);
                IsDepending := (Stream.Size > 0) and (Pos(ConstraintIndexName, AnsiUpperCase(Stream.DataString)) > 0);
              finally
                FreeAndNil(Stream);
              end;

              if IsDepending then
                 AddDrop(LocalSQL.Fields[0].AsString, LocalSQL.Fields[1].AsInteger, Level + 1);

              LocalSQL.Next;
            end;
            LocalSQL.Close;

            //    
            // walking dependent triggers
            LocalSQL.SQL.Text :=
              Format('select ' +
                     '  d.rdb$dependent_name, d.rdb$dependent_type, t.rdb$trigger_source ' +
                     'from ' +
                     '  rdb$dependencies d ' +
                     '  join rdb$triggers t on d.rdb$dependent_name = t.rdb$trigger_name ' +
                     'where ' +
                     '  d.rdb$depended_on_name = "%s" and ' +
                     '  d.rdb$dependent_type = 2 and ' +
                     '  d.rdb$field_name is null and ' +
                     '  not exists(select * ' +
                     '             from ' +
                     '               rdb$check_constraints cc ' +
                     '             where ' +
                     '               cc.rdb$trigger_name = t.rdb$trigger_name)', [RelationName]);

            LocalSQL.ExecQuery;
            while not LocalSQL.EOF do
            begin
              Stream := TStringStream.Create('');
              with Stream do
              try
                LocalSQL.Fields[2].SaveToStream(Stream);
                IsDepending := (Stream.Size > 0) and (Pos(ConstraintIndexName, AnsiUpperCase(Stream.DataString)) > 0);
              finally
                FreeAndNil(Stream);
              end;

              if IsDepending then
                 AddDrop(LocalSQL.Fields[0].AsString, LocalSQL.Fields[1].AsInteger, Level + 1);

              LocalSQL.Next;
            end;
            LocalSQL.Close;

            //    
            // walking dependent checks
            LocalSQL.SQL.Text :=
              Format('select ' +
                     '  cc.rdb$constraint_name, cast(4 as smallint), t.rdb$trigger_source ' +
                     'from ' +
                     '  rdb$dependencies d ' +
                     '  join rdb$triggers t on d.rdb$dependent_name = t.rdb$trigger_name ' +
                     '  join rdb$check_constraints cc on t.rdb$trigger_name = cc.rdb$trigger_name ' +
                     'where ' +
                     '  d.rdb$depended_on_name = "%s" and ' +
                     '  d.rdb$dependent_type = 2 and ' +
                     '  d.rdb$field_name is null', [RelationName]);

            LocalSQL.ExecQuery;
            while not LocalSQL.EOF do
            begin
              Stream := TStringStream.Create('');
              with Stream do
              try
                LocalSQL.Fields[2].SaveToStream(Stream);
                IsDepending := (Stream.Size > 0) and (Pos(ConstraintIndexName, AnsiUpperCase(Stream.DataString)) > 0);
              finally
                FreeAndNil(Stream);
              end;

              if IsDepending then
                 AddDrop(LocalSQL.Fields[0].AsString, LocalSQL.Fields[1].AsInteger, Level + 1);

              LocalSQL.Next;
            end;
            LocalSQL.Close;

            LocalSQL.SQL.Text := Format('drop index %s', [DependedName])
          end
          else
          begin
            LocalSQL.SQL.Text :=
               'select ' +
               '  i.rdb$index_name ' +
               'from ' +
               '  rdb$indices i ' +
               'where ' +
               '  (i.rdb$system_flag is null or i.rdb$system_flag = 0) and ' +
               '   i.rdb$index_name not starting with "RDB$" and ' +
               '   not exists(select * ' +
               '  	           from ' +
               '		             rdb$relation_constraints rc ' +
               '			         where ' +
               '			           rc.rdb$index_name = i.rdb$index_name)';

            LocalSQL.ExecQuery;
            while not LocalSQL.EOF do
            begin
              AddDrop(LocalSQL.Fields[0].AsString, 10, Level + 1);
              LocalSQL.Next;
            end;
            LocalSQL.Close;

            Exit;
          end;
        end;
        11: // udf
        begin
          if DependedName <> '*' then
            LocalSQL.SQL.Text := Format('drop external function %s', [DependedName])
          else
          begin
            LocalSQL.SQL.Text :=
              'select ' +
              '  f.rdb$function_name ' +
              'from ' +
              '  rdb$functions f ' +
              'where ' +
              '  f.rdb$system_flag is null or f.rdb$system_flag = 0';

            LocalSQL.ExecQuery;
            while not LocalSQL.EOF do
            begin
              AddDrop(LocalSQL.Fields[0].AsString, 11, Level + 1);
              LocalSQL.Next;
            end;
            LocalSQL.Close;

            Exit;
          end;
        end;
      end;

      try
        LocalSQL.ExecQuery;
      except
        on E:Exception do
          WriteLn(E.Message);
      end;

      if pfCommitRetaining in ProcessingFlags then
         LocalSQL.Transaction.CommitRetaining;

      DropSequence.Add(Format('%s=%d', [DependedName, DependedType]));
    except
      raise;
    end;
  finally
    FreeAndNil(LocalSQL);
  end;
end;

function IsCmdParam(const S: string): Boolean;
begin
  Result :=
    (AnsiCompareText(S, '-user') = 0) or
    (AnsiCompareText(S, '-password') = 0) or
    (AnsiCompareText(S, '-database') = 0) or
    (AnsiCompareText(S, '-silent') = 0) or
    (AnsiCompareText(S, '-ce') = 0) or
    (AnsiCompareText(S, '-v') = 0) or
    (AnsiCompareText(S, '-p') = 0) or
    (AnsiCompareText(S, '-t') = 0) or
    (AnsiCompareText(S, '-i') = 0) or
    (AnsiCompareText(S, '-c') = 0) or
    (AnsiCompareText(S, '-f') = 0) or
    (AnsiCompareText(S, '-x') = 0);
end;

begin
  if ParamCount = 0 then
  begin
    WriteLn;
    WriteLn('Sintax: gdrop [options]');
    WriteLn;
    WriteLn('  -database {"database name"}');
    WriteLn('  -user     {user name}');
    WriteLn('  -password {password}');
    WriteLn('  -silent   = silent processing');
    WriteLn('  -ce       = commit after each object');
    WriteLn('  -v {view1 view2 ... viewN |*}');
    WriteLn('  -p {sproc1 sproc2 ... sprocN |*}');
    WriteLn('  -t {trigger1 trigger2 ... triggerN |*}');
    WriteLn('  -i {index1 index2 ... indexN |*}');
    WriteLn('  -c {constraint1 constraint2 ... constraintN |*}');
    WriteLn('  -x {exception1 exception2 ... exceptionN |*}');
    WriteLn('  -f {udf1 udf2 ... udfN |*}');
    Halt(1);
  end;

  try
    //   
    // default values
    AUserName := 'sysdba'; APassword := 'masterke'; ProcessingFlags := [];

    //    , , 
    // take database name, user and password
    I := 1;
    while I <= ParamCount do
    begin
      if AnsiCompareText(ParamStr(I), '-user') = 0 then
      begin
        Inc(I);
        if I <= ParamCount then AUserName := ParamStr(I);
        Inc(I);
        Continue;
      end
      else if AnsiCompareText(ParamStr(I), '-password') = 0 then
      begin
        Inc(I);
        if I <= ParamCount then APassword := ParamStr(I);
        Inc(I);
        Continue;
      end
      else if AnsiCompareText(ParamStr(I), '-database') = 0 then
      begin
        Inc(I);
        if I <= ParamCount then ADatabaseName := ParamStr(I);
        Inc(I);
        Continue;
      end
      else if AnsiCompareText(ParamStr(I), '-silent') = 0 then
      begin
        Inc(I);
        Include(ProcessingFlags, pfSilent);
        Continue;
      end
      else if AnsiCompareText(ParamStr(I), '-ce') = 0 then
      begin
        Inc(I);
        Include(ProcessingFlags, pfCommitRetaining);
        Continue;
      end
      else
        Inc(I);
    end;

    ASQL := Nil; DropSequence := Nil;
    try
      DropSequence := TStringList.Create;

      ASQL := TIBSQL.Create(Nil);
      ASQL.Database := TIBDatabase.Create(ASQL);
      with ASQL.Database do
      begin
        DatabaseName := ADatabaseName;
        LoginPrompt := False;
        Params.Values['user_name'] := AUserName;
        Params.Values['password']  := APassword;
      end;

      ASQL.Transaction := TIBTransaction.Create(ASQL);

      ASQL.Transaction.DefaultDatabase := ASQL.Database;

      ASQL.Database.Open;

      if not (pfSilent in ProcessingFlags) then
        WriteLn('dropping metadata: ');

      ASQL.Transaction.StartTransaction;

      //  
      // dropping metadata objects
      I := 1;
      while I <= ParamCount do
      begin
        if AnsiCompareText(ParamStr(I), '-v') = 0 then
        begin
          Inc(I);
          while (I <= ParamCount) and not IsCmdParam(ParamStr(I)) do
          begin
            AddDrop(ParamStr(I), 1, 1);
            Inc(I);
          end;
          Continue;
        end
        else if AnsiCompareText(ParamStr(I), '-p') = 0 then
        begin
          Inc(I);
          while (I <= ParamCount) and not IsCmdParam(ParamStr(I)) do
          begin
            AddDrop(ParamStr(I), 5, 1);
            Inc(I);
          end;
          Continue;
        end
        else if AnsiCompareText(ParamStr(I), '-t') = 0 then
        begin
          Inc(I);
          while (I <= ParamCount) and not IsCmdParam(ParamStr(I)) do
          begin
            AddDrop(ParamStr(I), 2, 1);
            Inc(I);
          end;
          Continue;
        end
        else if AnsiCompareText(ParamStr(I), '-i') = 0 then
        begin
          Inc(I);
          while (I <= ParamCount) and not IsCmdParam(ParamStr(I)) do
          begin
            AddDrop(ParamStr(I), 10, 1);
            Inc(I);
          end;
          Continue;
        end
        else if AnsiCompareText(ParamStr(I), '-c') = 0 then
        begin
          Inc(I);
          while (I <= ParamCount) and not IsCmdParam(ParamStr(I)) do
          begin
            AddDrop(ParamStr(I), 4, 1);
            Inc(I);
          end;
          Continue;
        end
        else if AnsiCompareText(ParamStr(I), '-x') = 0 then
        begin
          Inc(I);
          while (I <= ParamCount) and not IsCmdParam(ParamStr(I)) do
          begin
            AddDrop(ParamStr(I), 7, 1);
            Inc(I);
          end;
          Continue;
        end
        else if AnsiCompareText(ParamStr(I), '-f') = 0 then
        begin
          Inc(I);
          while (I <= ParamCount) and not IsCmdParam(ParamStr(I)) do
          begin
            AddDrop(ParamStr(I), 11, 1);
            Inc(I);
          end;
          Continue;
        end
        else
          Inc(I);
      end;

      ASQL.Transaction.Commit;
    finally
      FreeAndNil(DropSequence);
      FreeAndNil(ASQL);
    end;

  except
    on E: Exception do
    begin
      Writeln(E.Message);
      Halt(2);
    end;
  end;
end.


