{*******************************************************************}
{                                                                   }
{    Copyright () 1998-2000 RCAV rcav@peterlink.ru                 }
{                                                                   }
{    :   (LOA)  loa@mail.ru                          }
{                                                                   }
{*******************************************************************}

// Support up to 4GB - 1 page GDB files
// No check for condition: page size MUST BE divisible to sector size

program gkill;
{$APPTYPE CONSOLE}
{$R-}
uses
  SysUtils, Classes, DB, IBDataBase, IBSQL, Windows, Math;

type
  RHeaderPage = packed record
    pag_type: Byte;
    pag_flags: Byte;
    pag_checksum: Word;
    pag_generation: LongWord;
    pag_seqno: LongWord;
    pag_offset: LongWord;
    
    hdr_page_size: Word;
    hdr_ods_version: Word;
  end;

  RPointerPage = packed record
    pag_type: Byte;
    pag_flags: Byte;
    pag_checksum: Word;
    pag_generation: LongWord;
    pag_seqno: LongWord;
    pag_offset: LongWord;
    
    ppg_sequence: Integer;
    ppg_next: Integer;
    ppg_count: Word;
    ppg_relation: Word;
    ppg_min_space: Word;
    ppg_max_space: Word;
    ppg_page: array [0..2048] of Integer;
  end;

  TIntArray = array of Integer;

procedure QuickSort(var A: TIntArray; L, R: Integer);
var
  I, J: Integer;
  P, T: Integer;
begin
  repeat
    I := L;
    J := R;
    P := A[(L + R) shr 1];
    repeat
      while A[I] - P < 0 do
        Inc(I);
      while A[J] - P > 0 do
        Dec(J);
      if I <= J then
      begin
        T := A[I];
        A[I] := A[J]; 
        A[J] := T;
        Inc(I);
        Dec(J);
      end;
    until I > J;
    if L < J then
      QuickSort(A, L, J);
    L := I;
  until I >= R;
end;
  
var
  ADatabaseName, AUserName, APassword: string;
  _IBSQL: TIBSQL;
  UserPages, SysPages, DeathPages: TIntArray;
  UserPagesCount, SysPagesCount, DeathPagesCount: Integer;
  GDBFile: Integer;
  HeaderPage: RHeaderPage;
  I: Integer;
  bClearUserDataPages: Boolean;

  procedure AddDeathPages(PageID: Integer; IncludeDataPages: Boolean);
  var
    I: Integer;
    PageDistance: Int64;
    PointerPage: RPointerPage;
  begin
    while PageID>0 do
    begin
      if DeathPagesCount = High(DeathPages) then SetLength(DeathPages, Length(DeathPages) + 4096);
      DeathPages[DeathPagesCount] := PageID;
      Inc(DeathPagesCount);
        
      // read page
      PageDistance := Int64(PageID) * HeaderPage.hdr_page_size;
      if FileSeek(GDBFile, PageDistance, FILE_BEGIN) < 0 then RaiseLastWin32Error;
      Assert(SizeOf(PointerPage) >= HeaderPage.hdr_page_size);
      if FileRead(GDBFile, PointerPage, HeaderPage.hdr_page_size) < 0 then RaiseLastWin32Error;

      // all data pages from this pointer page
      if IncludeDataPages then   
        for I := 0 to Min(PointerPage.ppg_count-1, 2048) do
        begin
          if DeathPagesCount = High(DeathPages) then SetLength(DeathPages, Length(DeathPages) + 4096);
          DeathPages[DeathPagesCount] := PointerPage.ppg_page[I];
          Inc(DeathPagesCount);
        end;

      // goto next pointer page
      PageID := PointerPage.ppg_next;
    end;
  end;

  procedure ClearDeathPages;
  var
    Buf: Pointer;
    I: Integer;
    PageDistance: Int64;
  begin
    Buf := VirtualAlloc(Nil, HeaderPage.hdr_page_size, MEM_COMMIT, PAGE_READWRITE);
    if GetLastError <> NO_ERROR then RaiseLastWin32Error;
    try
      Win32Check(VirtualLock(Buf, HeaderPage.hdr_page_size));
      try
        FillChar(PChar(Buf)^, HeaderPage.hdr_page_size, $FF);

        // FILE_FLAG_NO_BUFFERING !!! See MSDN for detailed description
        GDBFile := CreateFile(PChar(ADatabaseName), GENERIC_WRITE, FILE_SHARE_READ or FILE_SHARE_WRITE, Nil, 
          OPEN_EXISTING, FILE_FLAG_NO_BUFFERING or FILE_FLAG_SEQUENTIAL_SCAN, 0);
        if GDBFile < 0 then RaiseLastWin32Error;

        try
          for I := 0 to DeathPagesCount-1 do
          begin                     
            Write(Format('gkill: kill page %d (%d) (%2.0f%% complete)%s', [DeathPages[I], DeathPagesCount, I/DeathPagesCount*100, #13]));
            // setting to page
            PageDistance := Int64(DeathPages[I]) * HeaderPage.hdr_page_size;
            if FileSeek(GDBFile, PageDistance, FILE_BEGIN) < 0 then RaiseLastWin32Error;
            // clear page
            if FileWrite(GDBFile, Buf^, HeaderPage.hdr_page_size) < 0 then RaiseLastWin32Error;
          end;
          WriteLn;
        finally
          Win32Check(CloseHandle(GDBFile));
        end; 
      finally
        Win32Check(VirtualUnlock(Buf, HeaderPage.hdr_page_size));        
      end;      
    finally
      Win32Check(VirtualFree(Buf, 0, MEM_RELEASE));
    end;
  end;

begin
  if ParamCount = 0 then
  begin
    WriteLn('please retry, specifing an option');
    WriteLn('allowed options are:');
    WriteLn;
    WriteLn(' -user       default user name');
    WriteLn(' -password   default password');
    WriteLn(' -u          clear user table data pages');
    WriteLn(' "database name"');
    Halt(1);
  end;

  try
    // predefined user name and password
    AUserName := 'sysdba'; APassword := 'masterke';
    bClearUserDataPages := False;

    I := 1;
    while I <= ParamCount do
    begin
      if AnsiCompareText(ParamStr(I), '-user') = 0 then
      begin
        Inc(I);
        if I <= ParamCount then AUserName := ParamStr(I);  
        Continue;
      end else
      if AnsiCompareText(ParamStr(I), '-password') = 0 then
      begin
        Inc(I);
        if I <= ParamCount then APassword := ParamStr(I);  
        Continue;
      end else
      if AnsiCompareText(ParamStr(I), '-u') = 0 then
      begin 
        bClearUserDataPages := True;
        Inc(I);
        Continue;
      end else
      if AnsiCompareText(ParamStr(I)[1], '-') = 0 then
        raise Exception.Create('unknown option '+ParamStr(I))
      else
      begin
        ADatabaseName := ParamStr(I);
        Inc(I);
      end;
    end;
                 
    _IBSQL := TIBSQL.Create(nil);
    with _IBSQL do
    try 
      Database := TIBDatabase.Create(_IBSQL);
      with Database do
      begin
        DatabaseName := ADatabaseName;
        LoginPrompt := False;
        Params.Values['user_name'] := AUserName;
        Params.Values['password'] := APassword;
      end;   
      Transaction := TIBTransaction.Create(_IBSQL);
      Transaction.DefaultDatabase := Database;

      WriteLn('gkill: connecting database ', DataBase.DatabaseName);    
      DataBase.Open;
      Transaction.StartTransaction;  

      // retrieving death penalty pages, array step is 4096
      WriteLn('gkill: retrieving death penalty pages');

      // pointer pages (system)
      SetLength(SysPages, 4096);
      SysPagesCount := 0;

      // first pages with subtype = 4 for system tables
      SQL.Text := 
        'select p.rdb$page_number from rdb$pages p join rdb$relations r on p.rdb$relation_id=r.rdb$relation_id '+
        'where r.rdb$system_flag = 1 and p.rdb$page_type = 4 order by 1';
      ExecQuery;
      while not EOF do
      begin
        if SysPagesCount = High(SysPages) then SetLength(SysPages, Length(SysPages) + 4096);
        SysPages[SysPagesCount] := Fields[0].AsInteger;
        Inc(SysPagesCount);
        Next;
      end;
      Close;

      // pointer pages (user)
      SetLength(UserPages, 4096);
      UserPagesCount := 0;

      // first pages with subtype = 4 for user tables
      SQL.Text := 
        'select p.rdb$page_number from rdb$pages p join rdb$relations r on p.rdb$relation_id=r.rdb$relation_id '+
        'where r.rdb$system_flag <> 1 and p.rdb$page_type = 4 order by 1';
      ExecQuery;
      while not EOF do
      begin
        if UserPagesCount = High(UserPages) then SetLength(UserPages, Length(UserPages) + 4096);
        UserPages[UserPagesCount] := Fields[0].AsInteger;
        Inc(UserPagesCount);
        Next;
      end;
      Close;

      WriteLn('gkill: commit');    
      Transaction.Commit;    
    finally
      _IBSQL.Free;    
    end;

    // pages to clear
    SetLength(DeathPages, 4096);

    // gdb header pages
    DeathPages[0] := 0; 
    DeathPagesCount := 1;
    
    WriteLn('gkill: open database file and check data');
    GDBFile := FileOpen(ADatabaseName, fmOpenRead or fmShareDenyNone);
    if GDBFile < 0 then RaiseLastWin32Error; 
    try
      if FileRead(GDBFile, HeaderPage, SizeOf(HeaderPage)) < 0 then RaiseLastWin32Error;
      if HeaderPage.hdr_ods_version <> 10 then raise Exception.Create('Invalid ODS version');

      // all pages for system tables
      for I := 0 to SysPagesCount-1 do
        AddDeathPages(SysPages[I], True);

      // pointer pages for user tables
      for I := 0 to UserPagesCount-1 do
        AddDeathPages(UserPages[I], bClearUserDataPages);
      
    finally
      FileClose(GDBFile);
    end;

    QuickSort(DeathPages, 0, DeathPagesCount-1);

    WriteLn(Format('gkill: killing database ODS version = %d, page size = %d bytes',
      [HeaderPage.hdr_ods_version, HeaderPage.hdr_page_size]));
     
    ClearDeathPages;  

  except                             
    on E: Exception do
    begin
      Writeln(E.Message);
      Halt(2);
    end;
  end;
end.

    

